/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.importer.div.rs232;

import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.importer.div.rs232.Messages;
import ch.elexis.core.ui.importer.div.rs232.PortEventListener;
import ch.elexis.core.ui.importer.div.rs232.SerialConnectionException;
import ch.elexis.core.ui.importer.div.rs232.SerialParameters;
import ch.rgw.io.FileTool;
import ch.rgw.tools.ExHandler;
import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import gnu.io.UnsupportedCommOperationException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.TooManyListenersException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractConnection
implements PortEventListener {
    private static final String simulate = null;
    protected final StringBuilder sbFrame = new StringBuilder();
    protected final StringBuilder sbLine = new StringBuilder();
    protected int frameStart;
    protected int frameEnd;
    protected int overhang;
    protected int checksumBytes;
    protected final ComPortListener listener;
    protected long endTime;
    protected int timeToWait;
    private int timeout;
    private boolean adjustEndTime;
    private boolean closed = false;
    private static byte lineSeparator;
    private CommPortIdentifier portId;
    private SerialPort sPort;
    private boolean bOpen;
    protected OutputStream os;
    private InputStream is;
    private final String myPort;
    private final String[] mySettings;
    private final String name;
    private int state;
    private Thread watchdogThread;

    public AbstractConnection(String portName, String port, String settings, ComPortListener l) {
        this.listener = l;
        this.myPort = port;
        this.mySettings = settings.split(",");
        this.name = portName;
    }

    public String connect() {
        SerialParameters sp = new SerialParameters();
        sp.setPortName(this.myPort);
        sp.setBaudRate(this.mySettings[0]);
        sp.setDatabits(this.mySettings[1]);
        sp.setParity(this.mySettings[2]);
        sp.setStopbits(this.mySettings[3]);
        if (this.mySettings.length >= 5 && this.mySettings[4] != null) {
            sp.setFlowControlIn(this.mySettings[4]);
        }
        if (this.mySettings.length >= 6 && this.mySettings[5] != null) {
            sp.setFlowControlOut(this.mySettings[5]);
        }
        try {
            if (simulate != null) {
                final AbstractConnection mine = this;
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(1000L);
                            String in = FileTool.readTextFile((File)new File(simulate)).replaceAll("\\r\\n", "\r");
                            AbstractConnection.this.listener.gotData(mine, in.getBytes());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }).start();
            } else {
                this.sbLine.setLength(0);
                this.openConnection(sp);
            }
            return null;
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
            return ex.getMessage();
        }
    }

    private void openConnection(SerialParameters parameters) throws SerialConnectionException {
        try {
            this.portId = CommPortIdentifier.getPortIdentifier((String)parameters.getPortName());
        }
        catch (NoSuchPortException e) {
            String msg = e.getMessage();
            if (msg == null || msg.length() == 0) {
                msg = ((Object)((Object)e)).getClass().getSimpleName();
            }
            throw new SerialConnectionException(msg);
        }
        try {
            this.sPort = (SerialPort)this.portId.open(this.name, 1000);
        }
        catch (PortInUseException e) {
            throw new SerialConnectionException(Messages.AbstractConnection_ComPortInUse);
        }
        try {
            this.setConnectionParameters(parameters);
        }
        catch (SerialConnectionException e) {
            this.sPort.close();
            throw e;
        }
        try {
            this.os = this.sPort.getOutputStream();
            this.is = this.sPort.getInputStream();
        }
        catch (IOException e) {
            this.sPort.close();
            throw new SerialConnectionException("Error opening i/o streams");
        }
        try {
            this.sPort.addEventListener((SerialPortEventListener)this);
        }
        catch (TooManyListenersException e) {
            this.sPort.close();
            throw new SerialConnectionException("too many listeners added");
        }
        this.sPort.notifyOnDataAvailable(true);
        this.sPort.notifyOnBreakInterrupt(true);
        try {
            this.sPort.enableReceiveTimeout(30);
        }
        catch (UnsupportedCommOperationException e) {
            throw new SerialConnectionException("Unsupported Com operation");
        }
        this.bOpen = true;
    }

    public void setConnectionParameters(SerialParameters parameters) throws SerialConnectionException {
        int oldBaudRate = this.sPort.getBaudRate();
        int oldDatabits = this.sPort.getDataBits();
        int oldStopbits = this.sPort.getStopBits();
        int oldParity = this.sPort.getParity();
        try {
            this.sPort.setSerialPortParams(parameters.getBaudRate(), parameters.getDatabits(), parameters.getStopbits(), parameters.getParity());
        }
        catch (UnsupportedCommOperationException e) {
            parameters.setBaudRate(oldBaudRate);
            parameters.setDatabits(oldDatabits);
            parameters.setStopbits(oldStopbits);
            parameters.setParity(oldParity);
            throw new SerialConnectionException("Unsupported parameter");
        }
        try {
            this.sPort.setFlowControlMode(parameters.getFlowControlIn() | parameters.getFlowControlOut());
        }
        catch (UnsupportedCommOperationException e) {
            throw new SerialConnectionException("Unsupported flow control");
        }
    }

    public synchronized void awaitFrame(Shell shell, String text, int start, int end, int following, int timeout, boolean background, boolean adjustEndTime) {
        this.frameStart = start;
        this.frameEnd = end;
        this.overhang = following;
        this.timeout = timeout;
        this.adjustEndTime = adjustEndTime;
        this.endTime = System.currentTimeMillis() + (long)(timeout * 1000);
        this.watchdogThread = background ? new Thread(new BackgroundWatchdog()) : new Thread(new MonitoredWatchdog(shell, text));
        this.timeToWait = timeout;
        this.checksumBytes = this.overhang;
        this.watchdogThread.start();
    }

    public void serialEvent(SerialPortEvent e) {
        if (this.adjustEndTime) {
            this.endTime = System.currentTimeMillis() + (long)(this.timeout * 1000);
        }
        if (e.getEventType() == 10) {
            this.breakInterrupt(this.state);
        } else {
            try {
                this.serialEvent(this.state, this.is, e);
            }
            catch (Exception ex) {
                ExHandler.handle((Throwable)ex);
            }
        }
    }

    public abstract void serialEvent(int var1, InputStream var2, SerialPortEvent var3) throws IOException;

    public void breakInterrupt(int state) {
        this.watchdogThread.interrupt();
        this.listener.gotBreak(this);
    }

    public void close() {
        this.closed = true;
        if (this.watchdogThread != null && this.watchdogThread.isAlive()) {
            this.watchdogThread.interrupt();
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(500L);
                    AbstractConnection.this.sPort.close();
                    AbstractConnection.this.bOpen = false;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
    }

    public boolean isOpen() {
        return this.bOpen;
    }

    public void sendBreak() {
        if (this.sPort != null) {
            this.sPort.sendBreak(1000);
        } else {
            ExHandler.handle((Throwable)new Throwable("sPort is null"));
        }
    }

    public boolean send(String data) {
        return this.send(data.getBytes());
    }

    public boolean send(byte[] bytes) {
        try {
            this.os.write(bytes);
            this.os.flush();
            return true;
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
            return false;
        }
    }

    public static String[] getComPorts() {
        Enumeration ports = CommPortIdentifier.getPortIdentifiers();
        ArrayList<String> p = new ArrayList<String>();
        while (ports.hasMoreElements()) {
            CommPortIdentifier port = (CommPortIdentifier)ports.nextElement();
            p.add(port.getName());
        }
        return p.toArray(new String[0]);
    }

    protected void interruptWatchdog() {
        this.watchdogThread.interrupt();
    }

    public byte getLineSeparator() {
        return lineSeparator;
    }

    public void setState(int state) {
        this.state = state;
    }

    public int getState() {
        return this.state;
    }

    class BackgroundWatchdog
    implements Runnable {
        BackgroundWatchdog() {
        }

        @Override
        public void run() {
            while (System.currentTimeMillis() < AbstractConnection.this.endTime && !AbstractConnection.this.closed) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    return;
                }
            }
            if (AbstractConnection.this.closed) {
                AbstractConnection.this.listener.closed();
            } else {
                AbstractConnection.this.listener.timeout();
            }
        }
    }

    public static interface ComPortListener {
        public void gotData(AbstractConnection var1, byte[] var2);

        public void gotBreak(AbstractConnection var1);

        public void timeout();

        public void cancelled();

        public void closed();
    }

    class MonitoredWatchdog
    implements Runnable {
        final Shell shell;
        final String text;

        public MonitoredWatchdog(Shell shell, String text) {
            this.shell = shell;
            this.text = text;
        }

        @Override
        public void run() {
            final IRunnableWithProgress runnableWithProgress = new IRunnableWithProgress(){
                private int count = 0;

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.setTaskName(Messages.AbstractConnection_PleaseWait);
                    while (!monitor.isCanceled() && System.currentTimeMillis() < ((MonitoredWatchdog)MonitoredWatchdog.this).AbstractConnection.this.endTime && !((MonitoredWatchdog)MonitoredWatchdog.this).AbstractConnection.this.closed) {
                        if (this.count == 160) {
                            monitor.beginTask(MonitoredWatchdog.this.text, 100);
                            this.count = 0;
                        }
                        if (monitor.isCanceled()) {
                            monitor.done();
                            return;
                        }
                        monitor.worked(1);
                        ++this.count;
                        Thread.sleep(10L);
                    }
                    if (monitor.isCanceled()) {
                        ((MonitoredWatchdog)MonitoredWatchdog.this).AbstractConnection.this.listener.cancelled();
                    } else if (((MonitoredWatchdog)MonitoredWatchdog.this).AbstractConnection.this.closed) {
                        ((MonitoredWatchdog)MonitoredWatchdog.this).AbstractConnection.this.listener.closed();
                    } else {
                        ((MonitoredWatchdog)MonitoredWatchdog.this).AbstractConnection.this.listener.timeout();
                    }
                    monitor.done();
                }
            };
            Thread monitorDialogThread = new Thread(){

                @Override
                public void run() {
                    ProgressMonitorDialog dialog = new ProgressMonitorDialog(MonitoredWatchdog.this.shell);
                    try {
                        dialog.run(true, true, runnableWithProgress);
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            };
            UiDesk.getDisplay().asyncExec((Runnable)monitorDialogThread);
        }
    }
}

