/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.eigenartikel;

import ch.elexis.core.data.service.StockServiceHolder;
import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.services.IStockService;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.StoreToStringServiceHolder;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Optional;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;

public class EigenartikelTreeLabelProvider
extends LabelProvider
implements IColorProvider {
    @Inject
    private IEclipseContext eclipseContext;

    public EigenartikelTreeLabelProvider() {
        CoreUiUtil.injectServicesWithContext((Object)((Object)this));
    }

    public String getText(Object element) {
        MPart mPart;
        Long availability = null;
        IArticle article = (IArticle)element;
        availability = this.eclipseContext != null ? ((mPart = (MPart)this.eclipseContext.getActive(MPart.class)) != null && "ch.elexis.LeistungenView".equals(mPart.getElementId()) && ContextServiceHolder.get().getTyped(IEncounter.class).isPresent() ? this.getAvailability(article, Optional.of(((IEncounter)ContextServiceHolder.get().getTyped(IEncounter.class).get()).getMandator())) : this.getAvailability(article, ContextServiceHolder.get().getActiveMandator())) : StockServiceHolder.get().getCumulatedStockForArticle(article);
        if (availability != null) {
            return article.getLabel() + " (LB: " + String.valueOf(availability) + ")";
        }
        return article.getLabel();
    }

    private Long getAvailability(IArticle article, Optional<IMandator> mandator) {
        List stockEntries = StockServiceHolder.get().findAllStockEntriesForArticle(StoreToStringServiceHolder.getStoreToString((Object)article));
        if (!stockEntries.isEmpty()) {
            if (mandator.isPresent()) {
                return stockEntries.stream().filter(se -> se.getStock().getOwner() == null || se.getStock().getOwner().equals(mandator.get())).mapToInt(se -> se.getCurrentStock()).sum();
            }
            return stockEntries.stream().mapToInt(se -> se.getCurrentStock()).sum();
        }
        return null;
    }

    public Color getForeground(Object element) {
        IArticle article = (IArticle)element;
        IStockService.Availability availability = StockServiceHolder.get().getCumulatedAvailabilityForArticle(article);
        if (availability != null) {
            switch (availability) {
                case CRITICAL_STOCK: 
                case OUT_OF_STOCK: {
                    return UiDesk.getColor((String)"rot");
                }
            }
            return UiDesk.getColor((String)"blau");
        }
        return null;
    }

    public Color getBackground(Object element) {
        IArticle article = (IArticle)element;
        if (article.isProduct()) {
            return UiDesk.getColor((String)"himmelblau");
        }
        return null;
    }
}

