/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.documents.handler;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IXid;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.dialogs.KontaktSelektor;
import ch.elexis.core.ui.documents.fhir.FhirChCrlDocumentBundle;
import ch.elexis.data.Mandant;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.slf4j.LoggerFactory;

public class DocumentSendToCancerRegister
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Optional activePatient = ContextServiceHolder.get().getActivePatient();
        if (activePatient.isPresent()) {
            IXid ahv = ((IPatient)activePatient.get()).getXid("www.ahv.ch/xid");
            if (ahv == null || ahv.getDomainId() == null || ahv.getDomainId().length() < 13) {
                MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Senden an Krebsregister", (String)"Der Patient hat keine AHV Nummer mit min. 13 Zeichen.");
                return null;
            }
            ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
            if (selection instanceof StructuredSelection && !((StructuredSelection)selection).isEmpty()) {
                IDocument iDocument = (IDocument)((StructuredSelection)selection).getFirstElement();
                Optional<IMandator> author = this.getAuthor(iDocument);
                if (author.isPresent()) {
                    FhirChCrlDocumentBundle fhirBundle = new FhirChCrlDocumentBundle(iDocument, (IPatient)activePatient.get(), author.get());
                    try {
                        fhirBundle.writeTo(new File(CoreHub.getWritableUserDir(), "krg_test.xml"));
                    }
                    catch (IOException e) {
                        LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Couldn ot create file", (Throwable)e);
                        MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Senden an Krebsregister", (String)"Datei konnte nicht erstellt werden");
                    }
                } else {
                    MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Senden an Krebsregister", (String)"Kein Autor Mandant ausgew\u00e4hlt");
                }
            }
        } else {
            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Senden an Krebsregister", (String)"Kein Patient ausgew\u00e4hlt");
        }
        return null;
    }

    private Optional<IMandator> getAuthor(IDocument iDocument) {
        if (iDocument.getAuthor() != null && iDocument.getAuthor().isMandator()) {
            Optional ret = CoreModelServiceHolder.get().load(iDocument.getAuthor().getId(), IMandator.class);
            if (ret.isPresent()) {
                return ret;
            }
        } else {
            Mandant mandator;
            KontaktSelektor ksl = new KontaktSelektor(Display.getDefault().getActiveShell(), Mandant.class, "Mandant Auswahl", "Der Autor des Dokuments ausw\u00e4hlen. Der Autor wird dann dem Dokument zugewiesen.", new String[]{"Kuerzel", "Bezeichnung1", "Bezeichnung2"});
            if (ksl.open() == 0 && (mandator = (Mandant)ksl.getSelection()) != null) {
                Optional mandatorContact = CoreModelServiceHolder.get().load(mandator.getId(), IMandator.class);
                mandatorContact.ifPresent(m -> iDocument.setAuthor((IContact)m));
                return mandatorContact;
            }
        }
        return Optional.empty();
    }
}

