/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dbcheck.contributions;

import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.IQueryCursor;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.dbcheck.external.ExternalMaintenance;
import ch.elexis.core.utils.CoreUtil;
import ch.elexis.scripting.CSVWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.LoggerFactory;

public class ExportAllEncounters
extends ExternalMaintenance {
    @Override
    public String executeMaintenance(IProgressMonitor pm, String DBVersion) {
        File file = new File(CoreUtil.getWritableUserDir(), "ExportAllEncounters.csv");
        IQuery patientsQuery = CoreModelServiceHolder.get().getQuery(IPatient.class);
        int exportCounter = 0;
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (FileWriter fw = new FileWriter(file);){
                CSVWriter csv = new CSVWriter((Writer)fw);
                String[] header = new String[]{"PatNr", "PatId", "KonsId", "KonsText"};
                csv.writeNext(header);
                Throwable throwable2 = null;
                Object var12_16 = null;
                try (IQueryCursor cursor = patientsQuery.executeAsCursor();){
                    pm.beginTask("Bitte warten, alle Konsultationen werden exportieren", cursor.size());
                    while (cursor.hasNext()) {
                        IPatient patient = (IPatient)cursor.next();
                        for (ICoverage coverage : patient.getCoverages()) {
                            for (IEncounter encounter : coverage.getEncounters()) {
                                csv.writeNext(new String[]{patient.getPatientNr(), patient.getId(), encounter.getId(), encounter.getHeadVersionInPlaintext()});
                                ++exportCounter;
                            }
                        }
                        pm.worked(1);
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
                csv.close();
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LoggerFactory.getLogger(this.getClass()).error("Error writing csv");
            return "Die CSV Datei konnte nicht erstellt werden.";
        }
        return "Es wurden " + exportCounter + " Konsultationen in die Datei [" + file.getAbsolutePath() + "] geschrieben.";
    }

    @Override
    public String getMaintenanceDescription() {
        return "Alle Konsultationen als CSV exportieren.";
    }
}

