/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.contacts.views.util;

import ch.elexis.core.model.MimeType;
import ch.elexis.core.ui.contacts.dialogs.PatientCameraCaptureDialog;
import ch.elexis.core.ui.util.PatientImageUtil;
import ch.elexis.data.Patient;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CameraCaptureUtil {
    private static Logger logger = LoggerFactory.getLogger(CameraCaptureUtil.class);

    public static void openCameraAndSavePhoto(Patient patient, String patientName, Label photoLabel, Shell shell) {
        byte[] imageBytes = new PatientCameraCaptureDialog().openAndCaptureImage(shell);
        if (imageBytes == null || imageBytes.length == 0) {
            logger.warn("No photo captured or photo data is empty for patientId {}", (Object)patient);
            return;
        }
        PatientImageUtil.savePatientImage((String)patient.getId(), (byte[])imageBytes, (String)patientName, (MimeType)MimeType.png);
        Display.getDefault().asyncExec(() -> {
            try {
                Image scaledImage = PatientImageUtil.scaleSwtImage((Image)new Image((Device)Display.getDefault(), new ImageData((InputStream)new ByteArrayInputStream(imageBytes))), (int)130, (int)130, (Display)photoLabel.getDisplay());
                photoLabel.setImage(scaledImage);
            }
            catch (Exception e) {
                logger.error("Error displaying captured photo for patientId {}: {}", new Object[]{patient, e.getMessage(), e});
            }
        });
    }
}

