/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.contacts.controls;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.model.IContact;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.GlobalActions;
import ch.elexis.core.ui.views.provider.FaelleContentProvider;
import ch.elexis.core.ui.views.provider.FaelleLabelProvider;
import ch.elexis.data.Fall;
import ch.elexis.data.PersistentObject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class FaelleComposite
extends Composite {
    private TableViewer tableViewerFaelle;

    public FaelleComposite(Composite parent, int style, TabbedPropertySheetPage tpsp) {
        this(parent, style);
    }

    public FaelleComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(1, false));
        this.tableViewerFaelle = new TableViewer((Composite)this, 0);
        this.tableViewerFaelle.getTable().setBackground(UiDesk.getColor((String)"weiss"));
        this.tableViewerFaelle.getTable().setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.tableViewerFaelle.setLabelProvider((IBaseLabelProvider)new FaelleLabelProvider());
        this.tableViewerFaelle.setContentProvider((IContentProvider)new FaelleContentProvider());
        MenuManager menuManager = new MenuManager();
        menuManager.add((IContributionItem)new Separator("additions"));
        this.tableViewerFaelle.getTable().setMenu(menuManager.createContextMenu((Control)this.tableViewerFaelle.getTable()));
        menuManager.add(GlobalActions.openFallaction);
        menuManager.add(GlobalActions.makeBillAction);
        menuManager.add((IAction)GlobalActions.delFallAction);
        menuManager.add((IAction)GlobalActions.reopenFallAction);
        this.tableViewerFaelle.addSelectionChangedListener((ISelectionChangedListener)new FallSelectionChangedToEventDispatcher());
    }

    public void setContact(IContact k) {
        this.tableViewerFaelle.setInput((Object)k);
    }

    private class FallSelectionChangedToEventDispatcher
    implements ISelectionChangedListener {
        private FallSelectionChangedToEventDispatcher() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection selection = event.getSelection();
            if (selection == null) {
                return;
            }
            IStructuredSelection strucSelection = (IStructuredSelection)selection;
            Object selectedObject = strucSelection.getFirstElement();
            if (selectedObject == null) {
                return;
            }
            if (selectedObject instanceof Fall) {
                Fall f = (Fall)selectedObject;
                ElexisEventDispatcher.fireSelectionEvent((PersistentObject)f);
            }
        }
    }
}

