/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.tasks.internal.service;

import ch.elexis.core.model.tasks.IIdentifiedRunnable;
import ch.elexis.core.model.tasks.IIdentifiedRunnableFactory;
import ch.elexis.core.services.IAccessControlService;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IVirtualFilesystemService;
import ch.elexis.core.tasks.internal.runnables.DeleteFileIdentifiedRunnable;
import ch.elexis.core.tasks.internal.runnables.LogResultContextIdentifiedRunnable;
import ch.elexis.core.tasks.internal.runnables.RemoveTaskLogEntriesRunnable;
import ch.elexis.core.tasks.model.ITaskService;
import java.util.ArrayList;
import java.util.List;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true)
public class IdentifiedRunnableFactoryImpl
implements IIdentifiedRunnableFactory {
    @Reference
    private ITaskService taskService;
    @Reference
    private IVirtualFilesystemService virtualFilsystemService;
    private IModelService taskModelService;
    @Reference
    private IAccessControlService accessControlService;

    @Reference(target="(service.model.name=ch.elexis.core.tasks.model)")
    private void setModelService(IModelService modelService) {
        this.taskModelService = modelService;
    }

    @Activate
    public void activate() {
        this.accessControlService.doPrivileged(() -> this.taskService.bindIIdentifiedRunnableFactory(this));
    }

    @Deactivate
    public void deactivate() {
        this.taskService.unbindIIdentifiedRunnableFactory(this);
    }

    public List<IIdentifiedRunnable> getProvidedRunnables() {
        ArrayList<IIdentifiedRunnable> ret = new ArrayList<IIdentifiedRunnable>();
        ret.add(new LogResultContextIdentifiedRunnable());
        ret.add(new DeleteFileIdentifiedRunnable(this.virtualFilsystemService));
        ret.add(new RemoveTaskLogEntriesRunnable(this.taskModelService));
        return ret;
    }
}

