/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.spotlight.ui.internal;

import ch.elexis.core.documents.DocumentStore;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.model.IAppointment;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.IDocumentConverter;
import ch.elexis.core.services.IEncounterService;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.spotlight.ISpotlightResultEntry;
import ch.elexis.core.spotlight.ui.internal.SpotlightShell;
import ch.elexis.core.utils.OsgiServiceUtil;
import jakarta.inject.Inject;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.program.Program;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpotlightUiUtil {
    private static Logger logger = LoggerFactory.getLogger(SpotlightUiUtil.class);
    public static final String ACTION_SHOW_LATEST_LABORATORY = "sll::";
    public static final String ACTION_SHOW_LATEST_ENCOUNTER = "sle::";
    public static final String ACTION_SHOW_FIXED_MEDICATION = "sfm::";
    public static final String ACTION_SHOW_APPOINTMENT = "sam::";
    public static final String ACTION_SHOW_BALANCE = "sb::";
    @Inject
    private IContextService contextService;
    @Inject
    private DocumentStore documentStore;
    @Inject
    private IEncounterService encounterService;
    @Inject
    private ECommandService commandService;
    @Inject
    private EHandlerService handlerService;
    @Inject
    private IEclipseContext eclipseContext;
    private EPartService partService;

    public SpotlightUiUtil(EPartService partService) {
        this.partService = partService;
    }

    private boolean handleEnter(ISpotlightResultEntry selected) {
        if (selected == null) {
            return false;
        }
        ISpotlightResultEntry.Category category = selected.getCategory();
        String objectId = selected.getLoaderString();
        switch (category) {
            case PATIENT: {
                IPatient patient = CoreModelServiceHolder.get().load(objectId, IPatient.class).orElse(null);
                this.contextService.getRootContext().setTyped((Object)patient);
                return true;
            }
            case DOCUMENT: {
                IDocument document = this.documentStore.loadDocument(objectId, this.documentStore.getDefaultDocumentStore().getId()).orElse(null);
                if (document != null) {
                    try {
                        File tmpFile = File.createTempFile("doc", document.getExtension());
                        tmpFile.deleteOnExit();
                        this.documentStore.saveContentToFile(document, tmpFile.getAbsolutePath());
                        Program program = Program.findProgram((String)document.getExtension());
                        if (program != null) {
                            program.execute(tmpFile.getAbsolutePath());
                        }
                    }
                    catch (ElexisException | IOException e) {
                        LoggerFactory.getLogger(this.getClass()).info("Exception opening document [{}]", (Object)objectId, (Object)e);
                    }
                }
                return true;
            }
            case ENCOUNTER: {
                IEncounter encounter = CoreModelServiceHolder.get().load(objectId, IEncounter.class).orElse(null);
                return this.handleEnter(encounter);
            }
        }
        return false;
    }

    private boolean handleEnter(IEncounter encounter) {
        if (encounter != null) {
            this.contextService.getRootContext().setTyped((Object)encounter.getPatient());
            this.contextService.getRootContext().setTyped((Object)encounter);
            this.partService.showPart("ch.elexis.Konsdetail", EPartService.PartState.ACTIVATE);
            return true;
        }
        return false;
    }

    private boolean handleEnter(IAppointment appointment) {
        IContact contact;
        if (appointment != null && (contact = appointment.getContact()) != null) {
            IPatient patient = CoreModelServiceHolder.get().load(contact.getId(), IPatient.class).orElse(null);
            this.contextService.getRootContext().setTyped((Object)patient);
            this.partService.showPart("ch.elexis.agenda.largeview", EPartService.PartState.ACTIVATE);
            return true;
        }
        return false;
    }

    private boolean handleEnter(String string) {
        if (string.startsWith(ISpotlightResultEntry.Category.PATIENT.name())) {
            String patientId = string.substring(ISpotlightResultEntry.Category.PATIENT.name().length() + 2);
            IPatient patient = CoreModelServiceHolder.get().load(patientId, IPatient.class).orElse(null);
            if (patient == null) {
                logger.info("Could not load patient " + patientId);
            }
            this.contextService.getRootContext().setTyped((Object)patient);
            return patient != null;
        }
        if (string.startsWith(ACTION_SHOW_BALANCE)) {
            return this.performActionShowBalance(string.substring(ACTION_SHOW_BALANCE.length()));
        }
        if (string.startsWith(ACTION_SHOW_LATEST_LABORATORY)) {
            return this.performActionShowLatestLaboratory(string.substring(ACTION_SHOW_LATEST_LABORATORY.length()));
        }
        if (string.startsWith(ACTION_SHOW_LATEST_ENCOUNTER)) {
            return this.performActionShowLatestEncounter(string.substring(ACTION_SHOW_LATEST_ENCOUNTER.length()));
        }
        if (string.startsWith(ACTION_SHOW_APPOINTMENT)) {
            String appointmentId = string.substring(ACTION_SHOW_APPOINTMENT.length());
            IAppointment appointment = CoreModelServiceHolder.get().load(appointmentId, IAppointment.class).orElse(null);
            return this.handleEnter(appointment);
        }
        if (string.startsWith(ACTION_SHOW_FIXED_MEDICATION)) {
            String patientId = string.substring(ACTION_SHOW_FIXED_MEDICATION.length());
            return this.performActionShowFixedMedication(patientId);
        }
        return false;
    }

    private boolean performActionShowFixedMedication(String patientId) {
        boolean ok = this.handleEnter(ISpotlightResultEntry.Category.PATIENT.name() + "::" + patientId);
        if (ok) {
            this.partService.showPart("ch.elexis.core.ui.medication.views.MedicationView", EPartService.PartState.ACTIVATE);
            return true;
        }
        return false;
    }

    private boolean performActionShowLatestEncounter(String patientId) {
        IEncounter latestEncounter;
        IPatient patient;
        boolean ok = this.handleEnter(ISpotlightResultEntry.Category.PATIENT.name() + "::" + patientId);
        if (ok && (patient = (IPatient)this.contextService.getActivePatient().orElse(null)) != null && (latestEncounter = (IEncounter)this.encounterService.getLatestEncounter(patient).orElse(null)) != null) {
            return this.handleEnter(latestEncounter);
        }
        return false;
    }

    private boolean performActionShowLatestLaboratory(String patientId) {
        boolean ok = this.handleEnter(ISpotlightResultEntry.Category.PATIENT.name() + "::" + patientId);
        if (ok) {
            this.partService.showPart("ch.elexis.Labor", EPartService.PartState.ACTIVATE);
            return true;
        }
        return false;
    }

    public boolean handleEnter(Object selectedElement) {
        if (selectedElement instanceof IAppointment) {
            return this.handleEnter((IAppointment)selectedElement);
        }
        if (selectedElement instanceof IEncounter) {
            return this.handleEnter((IEncounter)selectedElement);
        }
        if (selectedElement instanceof ISpotlightResultEntry) {
            return this.handleEnter((ISpotlightResultEntry)selectedElement);
        }
        if (selectedElement instanceof Supplier) {
            return (Boolean)((Supplier)selectedElement).get();
        }
        if (selectedElement instanceof String) {
            return this.handleEnter((String)selectedElement);
        }
        return false;
    }

    private boolean performActionShowBalance(String patientId) {
        boolean ok = this.handleEnter(ISpotlightResultEntry.Category.PATIENT.name() + "::" + patientId);
        if (ok) {
            ParameterizedCommand command = this.commandService.createCommand("ch.elexis.core.ui.e4.command.part.show.invoicelist", Collections.singletonMap("filterOnCurrentPatient", "true"));
            this.eclipseContext.set(EPartService.class, (Object)this.partService);
            this.handlerService.executeHandler(command, this.eclipseContext);
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean handleDocumentSelectionAndPreview(Object firstElement, SpotlightShell _spotlightShell) {
        ISpotlightResultEntry selectedElement = (ISpotlightResultEntry)firstElement;
        String objectId = selectedElement.getLoaderString();
        IDocument document = this.documentStore.loadDocument(objectId, this.documentStore.getDefaultDocumentStore().getId()).orElse(null);
        if (document != null && "docx".equalsIgnoreCase(document.getExtension())) {
            Optional converterService = OsgiServiceUtil.getService(IDocumentConverter.class);
            if (!converterService.isPresent() || !((IDocumentConverter)converterService.get()).isAvailable()) return true;
            try {
                Optional pdfFile = ((IDocumentConverter)converterService.get()).convertToPdf(document);
                if (!pdfFile.isPresent()) return true;
                FileInputStream pdfStream = new FileInputStream((File)pdfFile.get());
                _spotlightShell.updatePdfPreview(pdfStream);
                _spotlightShell.adjustShellSize(true);
                return true;
            }
            catch (IOException e) {
                LoggerFactory.getLogger(this.getClass()).error("Error converting document [" + String.valueOf(document) + "]", (Throwable)e);
                return true;
            }
            finally {
                OsgiServiceUtil.ungetService(converterService.get());
            }
        }
        if (selectedElement.getCategory() == ISpotlightResultEntry.Category.DOCUMENT && document != null && "pdf".equalsIgnoreCase(document.getExtension())) {
            try {
                Throwable converterService = null;
                Object var7_12 = null;
                try (InputStream pdfStream = document.getContent();){
                    _spotlightShell.updatePdfPreview(pdfStream);
                    _spotlightShell.adjustShellSize(true);
                    return true;
                }
                catch (Throwable throwable) {
                    if (converterService == null) {
                        converterService = throwable;
                        throw converterService;
                    } else {
                        if (converterService == throwable) throw converterService;
                        converterService.addSuppressed(throwable);
                    }
                    throw converterService;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        _spotlightShell.adjustShellSize(false);
        return true;
    }
}

