/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services.internal.text;

import ch.elexis.core.interfaces.ILocalizedEnum;
import ch.elexis.core.model.ISickCertificate;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IContext;
import ch.elexis.core.text.ITextPlaceholderResolver;
import ch.elexis.core.text.PlaceholderAttribute;
import ch.elexis.core.time.TimeUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.component.annotations.Component;

@Component
public class AufTextPlaceholderResolver
implements ITextPlaceholderResolver {
    public String getSupportedType() {
        return "AUF";
    }

    public List<PlaceholderAttribute> getSupportedAttributes() {
        return Arrays.asList(AufAttribute.values()).stream().map(m -> new PlaceholderAttribute(this.getSupportedType(), m.name(), m.getLocaleText())).collect(Collectors.toList());
    }

    public Optional<String> replaceByTypeAndAttribute(IContext context, String attribute) {
        ISickCertificate sickCertificate = this.getIdentifiable(context).orElse(null);
        if (sickCertificate != null) {
            return Optional.ofNullable(this.replace(sickCertificate, attribute.toLowerCase()));
        }
        return Optional.empty();
    }

    public Optional<? extends Identifiable> getIdentifiable(IContext context) {
        Optional ret = context.getTyped(ISickCertificate.class);
        if (ret.isEmpty()) {
            ret = context.getNamed(this.getSupportedType());
        }
        return ret;
    }

    private String replace(ISickCertificate sickCertificate, String lcAttribute) {
        AufAttribute attribute = (AufAttribute)this.searchEnum(AufAttribute.class, lcAttribute);
        switch (attribute) {
            case Grund: {
                return StringUtils.defaultString((String)sickCertificate.getReason());
            }
            case Von: {
                return sickCertificate.getStart() != null ? TimeUtil.DATE_GER.format(sickCertificate.getStart()) : "";
            }
            case Bis: {
                return sickCertificate.getEnd() != null ? TimeUtil.DATE_GER.format(sickCertificate.getEnd()) : "";
            }
            case Prozent: {
                return Integer.toString(sickCertificate.getPercent());
            }
            case Zusatz: {
                return StringUtils.defaultString((String)sickCertificate.getNote());
            }
        }
        return null;
    }

    private static enum AufAttribute implements ILocalizedEnum
    {
        Grund("Grund der Arbeitsunf\u00e4higkeit"),
        Bis("Datum des Ende der Arbeitsunf\u00e4higkeit"),
        Prozent("Prozent der Arbeitsunf\u00e4higkeit"),
        Zusatz("Zusatz der Arbeitsunf\u00e4higkeit"),
        Von("Datum des Start der Arbeitsunf\u00e4higkeit");

        final String description;

        private AufAttribute(String description) {
            this.description = description;
        }

        public String getLocaleText() {
            return this.description;
        }
    }
}

