/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services.handler;

import ch.elexis.core.model.IAppointment;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class AppointmentExtensionHandler {
    public static final String MAIN_PREFIX = "Main:";
    public static final String KOMBI_PREFIX = "Kombi:";

    public static String getMainAppointmentId(IAppointment appointment) {
        String extension = appointment.getExtension();
        if (extension != null && !extension.isEmpty()) {
            return AppointmentExtensionHandler.extractIdByPrefix(extension, MAIN_PREFIX);
        }
        return null;
    }

    public static boolean isMainAppointment(IAppointment appointment) {
        String mainId = AppointmentExtensionHandler.getMainAppointmentId(appointment);
        return appointment.getId().equals(mainId);
    }

    public static List<IAppointment> getLinkedAppointments(IAppointment mainAppointment) {
        ArrayList<IAppointment> linkedAppointments = new ArrayList<IAppointment>();
        String extension = mainAppointment.getExtension();
        if (extension != null && !extension.isEmpty()) {
            String[] parts;
            String[] stringArray = parts = extension.split(",");
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                if (part.startsWith(KOMBI_PREFIX)) {
                    String id = part.replace(KOMBI_PREFIX, "").trim();
                    Optional linkedAppointment = CoreModelServiceHolder.get().load(id, IAppointment.class);
                    linkedAppointment.ifPresent(linkedAppointments::add);
                }
                ++n2;
            }
        }
        return linkedAppointments;
    }

    public static List<IAppointment> getAllRelatedAppointments(IAppointment appointment) {
        ArrayList<IAppointment> allRelatedAppointments = new ArrayList<IAppointment>();
        String mainAppointmentId = AppointmentExtensionHandler.getMainAppointmentId(appointment);
        if (mainAppointmentId != null && !mainAppointmentId.isEmpty()) {
            Optional mainAppointment = CoreModelServiceHolder.get().load(mainAppointmentId, IAppointment.class);
            if (mainAppointment.isPresent()) {
                allRelatedAppointments.add((IAppointment)mainAppointment.get());
                List<IAppointment> linkedAppointments = AppointmentExtensionHandler.getLinkedAppointments((IAppointment)mainAppointment.get());
                allRelatedAppointments.addAll(linkedAppointments);
            }
        } else {
            allRelatedAppointments.add(appointment);
            List<IAppointment> linkedAppointments = AppointmentExtensionHandler.getLinkedAppointments(appointment);
            allRelatedAppointments.addAll(linkedAppointments);
        }
        return allRelatedAppointments;
    }

    public static void setMainAppointmentId(IAppointment appointment, String mainId) {
        StringBuilder extensionBuilder = new StringBuilder();
        String currentExtension = appointment.getExtension();
        if (currentExtension != null && !currentExtension.isEmpty()) {
            String[] parts;
            String[] stringArray = parts = currentExtension.split("\\|\\|");
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                if (!part.startsWith(MAIN_PREFIX) && !part.startsWith(KOMBI_PREFIX)) {
                    extensionBuilder.append(part).append("||");
                }
                ++n2;
            }
        }
        extensionBuilder.append(MAIN_PREFIX).append(mainId);
        appointment.setExtension(extensionBuilder.toString());
    }

    public static void addLinkedAppointmentId(IAppointment appointment, String linkedId) {
        StringBuilder extensionBuilder = new StringBuilder((String)(appointment.getExtension() != null ? appointment.getExtension() + "," : ""));
        extensionBuilder.append(KOMBI_PREFIX).append(linkedId);
        appointment.setExtension(extensionBuilder.toString());
    }

    private static String extractIdByPrefix(String extension, String prefix) {
        String[] parts;
        String[] stringArray = parts = extension.split(",");
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            if (part.startsWith(prefix)) {
                return part.replace(prefix, "").trim();
            }
            ++n2;
        }
        return null;
    }

    public static void addMultipleLinkedAppointments(IAppointment mainAppointment, List<String> linkedAppointmentIds) {
        StringBuilder extensionBuilder = new StringBuilder((String)(mainAppointment.getExtension() != null ? mainAppointment.getExtension() + "," : ""));
        for (String linkedId : linkedAppointmentIds) {
            extensionBuilder.append(KOMBI_PREFIX).append(linkedId).append(",");
        }
        if (extensionBuilder.length() > 0 && extensionBuilder.charAt(extensionBuilder.length() - 1) == ',') {
            extensionBuilder.setLength(extensionBuilder.length() - 1);
        }
        mainAppointment.setExtension(extensionBuilder.toString());
    }

    public static String addMultipleLinkedAppointmentsAndReturn(IAppointment mainAppointment, List<String> linkedAppointmentIds) {
        AppointmentExtensionHandler.addMultipleLinkedAppointments(mainAppointment, linkedAppointmentIds);
        return mainAppointment.getExtension();
    }
}

