/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services;

import ch.elexis.core.l10n.Messages;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IPerson;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IContext;
import ch.elexis.core.services.ITextReplacementService;
import ch.elexis.core.text.ITextPlaceholderResolver;
import ch.elexis.core.types.Gender;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.LoggerFactory;

@Component
public class TextReplacementService
implements ITextReplacementService {
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policyOption=ReferencePolicyOption.GREEDY)
    private List<ITextPlaceholderResolver> placeholderResolvers;
    private Pattern matchTemplate;
    private Pattern matchGenderize;
    private Pattern matchDataAccess;

    @Activate
    public void activate() {
        this.matchTemplate = Pattern.compile("\\[[*]?[-a-zA-Z\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00e9\u00e0\u00e8_ ]+\\.[-a-zA-Z0-9\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00e9\u00e0\u00e8_ ]+\\]");
        this.matchGenderize = Pattern.compile("\\[[*]?[a-zA-Z]+:mwn?:[^\\[]+\\]");
        this.matchDataAccess = Pattern.compile("\\[[*]?[-_a-zA-Z0-9]+:[-a-zA-Z0-9]+:[-a-zA-Z0-9\\.]+:[-a-zA-Z0-9\\.]:?[^\\]]*\\]");
    }

    private String replacePlaceholder(IContext context, String placeholder) {
        String substring = placeholder.substring(1, placeholder.length() - 1);
        String[] split = substring.split("\\.");
        if (split.length > 1) {
            for (ITextPlaceholderResolver resolver : this.placeholderResolvers) {
                Optional result;
                if (!resolver.getSupportedType().equalsIgnoreCase(split[0]) || !(result = resolver.replaceByTypeAndAttribute(context, substring.substring(split[0].length() + 1))).isPresent()) continue;
                return (String)result.get();
            }
        }
        return "?";
    }

    public List<ITextPlaceholderResolver> getResolvers() {
        return this.placeholderResolvers;
    }

    public String performReplacement(IContext context, String template, String newLinePattern) {
        String found;
        Matcher matcher = this.matchTemplate.matcher(template);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            found = matcher.group();
            matcher.appendReplacement(sb, Matcher.quoteReplacement(this.replacePlaceholder(context, found)));
        }
        matcher.appendTail(sb);
        matcher = this.matchGenderize.matcher(sb.toString());
        sb = new StringBuffer();
        while (matcher.find()) {
            found = matcher.group();
            matcher.appendReplacement(sb, Matcher.quoteReplacement(this.replaceGenderize(context, found)));
        }
        matcher.appendTail(sb);
        matcher = this.matchDataAccess.matcher(sb.toString());
        sb = new StringBuffer();
        while (matcher.find()) {
            found = matcher.group();
            matcher.appendReplacement(sb, Matcher.quoteReplacement(this.replaceDataAccess(context, found)));
        }
        matcher.appendTail(sb);
        return sb.toString().replaceAll("(\r\n|\n\r|\r|\n)", newLinePattern);
    }

    private String replaceGenderize(IContext context, String found) {
        String inl = found.substring(1, found.length() - 1);
        boolean showErrors = true;
        if (inl.substring(0, 1).equalsIgnoreCase("*")) {
            inl = inl.substring(1);
            showErrors = false;
        }
        Identifiable identifiable = null;
        String[] split = inl.split(":");
        for (ITextPlaceholderResolver resolver : this.placeholderResolvers) {
            if (resolver.getSupportedType().equalsIgnoreCase(split[0]) && (identifiable = (Identifiable)resolver.getIdentifiable(context).orElse(null)) != null) break;
        }
        if (identifiable == null) {
            if (showErrors) {
                return "???";
            }
            return "";
        }
        if (split.length != 3) {
            LoggerFactory.getLogger(this.getClass()).error("Invalid genderize Format [" + inl + "]");
            return null;
        }
        if (!(identifiable instanceof IContact)) {
            if (showErrors) {
                return Messages.TextContainer_FieldTypeForContactsOnly;
            }
            return "";
        }
        IContact contact = (IContact)identifiable;
        String[] g = split[2].split("/");
        if (g.length < 2) {
            if (showErrors) {
                return Messages.TextContainer_BadFieldDefinition;
            }
            return "";
        }
        if (contact.isPerson()) {
            IPerson person = contact.asIPerson();
            if (person.getGender() == Gender.MALE) {
                if (split[1].startsWith("m")) {
                    return g[0].trim();
                }
                return g[1].trim();
            }
            if (split[1].startsWith("w")) {
                return g[0].trim();
            }
            return g[1].trim();
        }
        if (g.length < 3) {
            if (showErrors) {
                return Messages.TextContainer_FieldTypeForPersonsOnly;
            }
            return "";
        }
        return g[2];
    }

    private String replaceDataAccess(IContext context, String placeholder) {
        String substring = placeholder.substring(1, placeholder.length() - 1);
        String[] adr = substring.split(":");
        if (adr.length < 4) {
            LoggerFactory.getLogger(this.getClass()).warn("Invalid data access placeholder [" + substring + "]");
            return null;
        }
        String type = adr[0];
        String dependendObject = adr[1];
        String dates = adr[2];
        String desc = adr[3];
        String[] params = null;
        if (adr.length == 5) {
            params = adr[4].split("\\.");
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{type}) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{desc})) {
            for (ITextPlaceholderResolver resolver : this.placeholderResolvers) {
                Optional result;
                if (!resolver.getSupportedType().equalsIgnoreCase(type) || !(result = resolver.replaceByTypeAndAttribute(context, desc)).isPresent()) continue;
                return (String)result.get();
            }
        }
        return "?";
    }
}

