/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services;

import ch.elexis.core.l10n.Messages;
import ch.elexis.core.model.BillingSystem;
import ch.elexis.core.model.FallConstants;
import ch.elexis.core.model.IBillingSystem;
import ch.elexis.core.model.ch.BillingLaw;
import ch.elexis.core.services.IBillingSystemService;
import ch.elexis.core.services.IConfigService;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.LoggerFactory;

@Component
public class BillingSystemService
implements IBillingSystemService {
    @Reference
    public IConfigService configService;
    private LoadingCache<String, BillingSystem> cache = CacheBuilder.newBuilder().expireAfterAccess(15L, TimeUnit.SECONDS).build((CacheLoader)new BillingSystemLoader());
    private static final String CFG_KEY_BILLINGLAW = "defaultBillingLaw";

    public String getOptionals(IBillingSystem system) {
        String value = this.configService.get("billing/systems/" + system.getName() + "/fakultativ", null);
        return value;
    }

    public String getRequirements(IBillingSystem system) {
        String value = this.configService.get("billing/systems/" + system.getName() + "/bedingungen", null);
        return value;
    }

    public String getDefaultPrintSystem(IBillingSystem system) {
        String value = this.configService.get("billing/systems/" + system.getName() + "/standardausgabe", null);
        return value;
    }

    public String getDefaultInsuranceReason(IBillingSystem system) {
        String value = this.configService.get("billing/systems/" + system.getName() + "/standardgrund", null);
        if (value == null) {
            value = system.getLaw() == BillingLaw.UVG ? FallConstants.TYPE_ACCIDENT : FallConstants.TYPE_DISEASE;
        }
        return value;
    }

    public List<String> getBillingSystemConstants(IBillingSystem billingSystem) {
        String bc = this.configService.get("billing/systems/" + String.valueOf(billingSystem) + "/constants", null);
        if (bc == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(bc.split("#"));
    }

    public String getBillingSystemConstant(IBillingSystem billingSystem, String name) {
        List<String> constants = this.getBillingSystemConstants(billingSystem);
        for (String bc : constants) {
            String[] val = bc.split("=");
            if (!val[0].equalsIgnoreCase(name)) continue;
            return val[1];
        }
        return "";
    }

    public IBillingSystem getDefaultBillingSystem() {
        Optional<IBillingSystem> billingSystem = this.getBillingSystem("KVG");
        if (billingSystem.isPresent()) {
            return billingSystem.get();
        }
        return this.addOrModifyBillingSystem(Messages.Case_KVG_Short, Messages.Fall_TarmedPrinter, Messages.Fall_KVGRequirements, BillingLaw.KVG);
    }

    public Optional<IBillingSystem> getBillingSystem(String name) {
        try {
            BillingSystem ret;
            if (name != null && (ret = (BillingSystem)this.cache.get((Object)name)) != BillingSystem.UNKNOWN) {
                return Optional.of(ret);
            }
        }
        catch (ExecutionException e) {
            LoggerFactory.getLogger(this.getClass()).warn("Error getting billing system [" + name + "]", (Throwable)e);
        }
        return Optional.empty();
    }

    public BillingLaw getBillingLaw(String law) {
        if (StringUtils.isNotBlank((CharSequence)law)) {
            if ("MVG".equals(law)) {
                law = "MV";
            }
            if ("IVG".equals(law)) {
                law = "IV";
            }
            return BillingLaw.valueOf((String)law);
        }
        LoggerFactory.getLogger(this.getClass()).warn("Could not determine law [" + law + "]");
        return null;
    }

    public List<IBillingSystem> getBillingSystems() {
        List subNodes = this.configService.getSubNodes("billing/systems");
        if (!subNodes.isEmpty()) {
            return subNodes.stream().map(node -> this.getBillingSystem((String)node).orElse(null)).filter(bs -> bs != null).collect(Collectors.toList());
        }
        LoggerFactory.getLogger(this.getClass()).warn("No billing systems configured");
        return Collections.emptyList();
    }

    public IBillingSystem addOrModifyBillingSystem(String name, String defaultPrinter, String requirements, BillingLaw law) {
        this.setConfigurationValue(name, "name", name);
        if (defaultPrinter != null) {
            this.setConfigurationValue(name, "standardausgabe", defaultPrinter);
        }
        this.setConfigurationValue(name, "bedingungen", requirements);
        this.setConfigurationValue(name, CFG_KEY_BILLINGLAW, law.name());
        this.cache.invalidateAll();
        return new BillingSystem(name, law);
    }

    private String getConfigurationValue(String billingSystemName, String attributeName, String defaultIfNotDefined) {
        String ret = this.configService.get("billing/systems/" + billingSystemName + "/" + attributeName, defaultIfNotDefined);
        return ret;
    }

    private void setConfigurationValue(String billingSystemName, String attributeName, String attributeValue) {
        String key = "billing/systems/" + billingSystemName;
        this.configService.set(key + "/" + attributeName, attributeValue);
    }

    private class BillingSystemLoader
    extends CacheLoader<String, BillingSystem> {
        private BillingSystemLoader() {
        }

        public BillingSystem load(String key) throws Exception {
            String billingSystemName = BillingSystemService.this.getConfigurationValue(key, "name", null);
            if (billingSystemName != null) {
                String configuredLaw = BillingSystemService.this.getConfigurationValue(key, BillingSystemService.CFG_KEY_BILLINGLAW, null);
                if (configuredLaw != null) {
                    BillingLaw law = BillingSystemService.this.getBillingLaw(configuredLaw);
                    if (law != null) {
                        BillingSystem billingSystem = new BillingSystem(key, law);
                        return billingSystem;
                    }
                } else {
                    LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("Could not determine law for billing system [" + key + "]");
                }
            }
            return BillingSystem.UNKNOWN;
        }
    }
}

