/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services.vfs;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Base64;
import org.junit.AssumptionViolatedException;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class AssumingWebdavConnection
implements TestRule {
    private URL connectionUrl;

    public AssumingWebdavConnection(String connection) {
        try {
            String replaced = connection.replaceFirst("davs", "https");
            this.connectionUrl = new URL(replaced);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                Object basicAuth;
                URLConnection conn = AssumingWebdavConnection.this.connectionUrl.openConnection();
                if (AssumingWebdavConnection.this.connectionUrl.getUserInfo() != null) {
                    basicAuth = "Basic " + new String(Base64.getEncoder().encode(AssumingWebdavConnection.this.connectionUrl.getUserInfo().getBytes()));
                    conn.setRequestProperty("Authorization", (String)basicAuth);
                }
                try {
                    basicAuth = null;
                    Object var3_5 = null;
                    try (InputStream is = conn.getInputStream();){
                        is.read();
                    }
                    catch (Throwable throwable) {
                        if (basicAuth == null) {
                            basicAuth = throwable;
                        } else if (basicAuth != throwable) {
                            ((Throwable)basicAuth).addSuppressed(throwable);
                        }
                        throw basicAuth;
                    }
                }
                catch (Exception e) {
                    throw new AssumptionViolatedException("Could not connect. Skipping test!");
                }
                base.evaluate();
            }
        };
    }
}

