/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services;

import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.ILaboratory;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IUser;
import ch.elexis.core.services.BriefDocumentStoreTest;
import ch.elexis.core.services.IAppointmentServiceTest;
import ch.elexis.core.services.IBillingServiceTest;
import ch.elexis.core.services.IConfigServiceTest;
import ch.elexis.core.services.IContactServiceTest;
import ch.elexis.core.services.IContextServiceTest;
import ch.elexis.core.services.ICoverageServiceTest;
import ch.elexis.core.services.IDocumentServiceTest;
import ch.elexis.core.services.IElexisEntityManager;
import ch.elexis.core.services.IEncounterServiceTest;
import ch.elexis.core.services.IInvoiceServiceTest;
import ch.elexis.core.services.ILabServiceTest;
import ch.elexis.core.services.IMedicationServiceTest;
import ch.elexis.core.services.IMessageServiceTest;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IOrderServiceTest;
import ch.elexis.core.services.IStickerServiceTest;
import ch.elexis.core.services.IStockServiceTest;
import ch.elexis.core.services.IStoreToStringServiceTest;
import ch.elexis.core.services.ITextReplacementServiceTest;
import ch.elexis.core.services.IUserServiceTest;
import ch.elexis.core.services.IVirtualFilesystemServiceTest;
import ch.elexis.core.services.IXidServiceTest;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.internal.RoleBasedAccessControlServiceTest;
import ch.elexis.core.test.initializer.TestDatabaseInitializer;
import ch.elexis.core.utils.OsgiServiceUtil;
import java.io.IOException;
import java.sql.SQLException;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;

@RunWith(value=Suite.class)
@Suite.SuiteClasses(value={RoleBasedAccessControlServiceTest.class, IContextServiceTest.class, IAppointmentServiceTest.class, IBillingServiceTest.class, IConfigServiceTest.class, ILabServiceTest.class, IStoreToStringServiceTest.class, IStickerServiceTest.class, BriefDocumentStoreTest.class, IUserServiceTest.class, IMessageServiceTest.class, IVirtualFilesystemServiceTest.class, IXidServiceTest.class, IMedicationServiceTest.class, ITextReplacementServiceTest.class, IEncounterServiceTest.class, IInvoiceServiceTest.class, ICoverageServiceTest.class, IContactServiceTest.class, IDocumentServiceTest.class, IStockServiceTest.class, IOrderServiceTest.class})
public class AllServiceTests {
    private static IModelService modelService;
    private static IElexisEntityManager entityManager;
    private static TestDatabaseInitializer tdb;

    @BeforeClass
    public static void beforeClass() throws IOException, SQLException {
        modelService = (IModelService)OsgiServiceUtil.getService(IModelService.class, (String)"(service.model.name=ch.elexis.core.model)").get();
        entityManager = (IElexisEntityManager)OsgiServiceUtil.getService(IElexisEntityManager.class).get();
        tdb = new TestDatabaseInitializer(modelService, entityManager);
        tdb.initializePatient();
        tdb.initializeMandant();
        tdb.initializeLabResult();
        tdb.initializePrescription();
        tdb.initializeFall();
        ContextServiceHolder.get().setActiveUser(TestDatabaseInitializer.getUser());
    }

    public static IModelService getModelService() {
        return modelService;
    }

    public static IPatient getPatient() {
        return TestDatabaseInitializer.getPatient();
    }

    public static ILaboratory getLaboratory() {
        return tdb.getLaboratory();
    }

    public static IArticle getEigenartikel() {
        return tdb.getArticle();
    }

    public static ICoverage getCoverage() {
        return TestDatabaseInitializer.getFall();
    }

    public static IMandator getMandator() {
        return TestDatabaseInitializer.getMandant();
    }

    public static IUser getUser() {
        return TestDatabaseInitializer.getUser();
    }
}

