/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model;

import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.entities.Fall;
import ch.elexis.core.jpa.entities.Kontakt;
import ch.elexis.core.jpa.model.adapter.AbstractIdDeleteModelAdapter;
import ch.elexis.core.jpa.model.adapter.AbstractIdModelAdapter;
import ch.elexis.core.l10n.Messages;
import ch.elexis.core.model.FallConstants;
import ch.elexis.core.model.IBillingSystem;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.IdentifiableWithXid;
import ch.elexis.core.model.service.holder.CoreModelServiceHolder;
import ch.elexis.core.model.service.holder.IBillingSystemServiceHolder;
import ch.elexis.core.model.util.internal.ModelUtil;
import ch.elexis.core.time.TimeUtil;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class Coverage
extends AbstractIdDeleteModelAdapter<Fall>
implements IdentifiableWithXid,
ICoverage {
    public Coverage(Fall entity) {
        super((EntityWithId)entity);
    }

    public Object getExtInfo(Object key) {
        return this.extInfoHandler.getExtInfo(key);
    }

    public void setExtInfo(Object key, Object value) {
        this.extInfoHandler.setExtInfo(key, value);
    }

    public Map<Object, Object> getMap() {
        return this.extInfoHandler.getMap();
    }

    public IPatient getPatient() {
        return ModelUtil.getAdapter((EntityWithId)((Fall)this.getEntity()).getPatient(), IPatient.class, true);
    }

    public void setPatient(IPatient value) {
        if (this.getPatient() != null) {
            this.addRefresh((Identifiable)this.getPatient());
        }
        if (value != null) {
            ((Fall)this.getEntityMarkDirty()).setPatient((Kontakt)((AbstractIdModelAdapter)value).getEntity());
            this.addRefresh((Identifiable)value);
        } else {
            ((Fall)this.getEntityMarkDirty()).setPatient(null);
        }
    }

    public String getDescription() {
        return ((Fall)this.getEntity()).getBezeichnung();
    }

    public void setDescription(String value) {
        ((Fall)this.getEntityMarkDirty()).setBezeichnung(value);
    }

    public String getReason() {
        return ((Fall)this.getEntity()).getGrund();
    }

    public void setReason(String value) {
        ((Fall)this.getEntityMarkDirty()).setGrund(value);
    }

    public LocalDate getDateFrom() {
        return ((Fall)this.getEntity()).getDatumVon();
    }

    public void setDateFrom(LocalDate value) {
        ((Fall)this.getEntityMarkDirty()).setDatumVon(value);
    }

    public LocalDate getDateTo() {
        return ((Fall)this.getEntity()).getDatumBis();
    }

    public void setDateTo(LocalDate value) {
        ((Fall)this.getEntityMarkDirty()).setDatumBis(value);
    }

    public IBillingSystem getBillingSystem() {
        IBillingSystem billingSystem = IBillingSystemServiceHolder.get().getBillingSystem(((Fall)this.getEntity()).getGesetz()).orElse(null);
        if (billingSystem == null) {
            billingSystem = IBillingSystemServiceHolder.get().getDefaultBillingSystem();
        }
        return billingSystem;
    }

    public void setBillingSystem(IBillingSystem value) {
        ((Fall)this.getEntityMarkDirty()).setGesetz(value.getName());
    }

    public IContact getCostBearer() {
        return ModelUtil.getAdapter((EntityWithId)((Fall)this.getEntity()).getKostentrKontakt(), IContact.class, true);
    }

    public void setCostBearer(IContact value) {
        if (value != null) {
            ((Fall)this.getEntityMarkDirty()).setKostentrKontakt((Kontakt)((AbstractIdModelAdapter)value).getEntity());
        } else {
            ((Fall)this.getEntityMarkDirty()).setKostentrKontakt(null);
        }
    }

    public IContact getGuarantor() {
        if (((Fall)this.getEntity()).getGarantKontakt() == null || ((Fall)this.getEntity()).getGarantKontakt().isDeleted()) {
            return this.getPatient();
        }
        IContact ret = ModelUtil.getAdapter((EntityWithId)((Fall)this.getEntity()).getGarantKontakt(), IContact.class, true);
        if (ret != null && ret.isPatient()) {
            ret = (IContact)ModelUtil.getAdapter((EntityWithId)((Fall)this.getEntity()).getGarantKontakt(), IPatient.class, true);
        }
        return ret;
    }

    public void setGuarantor(IContact value) {
        if (value != null) {
            ((Fall)this.getEntityMarkDirty()).setGarantKontakt((Kontakt)((AbstractIdModelAdapter)value).getEntity());
        } else {
            ((Fall)this.getEntityMarkDirty()).setGarantKontakt(null);
        }
    }

    public String getInsuranceNumber() {
        Object extInfoInsuranceNumber;
        String insuranceNumber = ((Fall)this.getEntity()).getVersNummer();
        if (StringUtils.isEmpty((CharSequence)insuranceNumber) && (extInfoInsuranceNumber = this.getExtInfo(FallConstants.FLD_EXT_VERSICHERUNGSNUMMER)) instanceof String && StringUtils.isNotBlank((CharSequence)((String)extInfoInsuranceNumber))) {
            return (String)extInfoInsuranceNumber;
        }
        return insuranceNumber;
    }

    public void setInsuranceNumber(String value) {
        ((Fall)this.getEntityMarkDirty()).setVersNummer(value);
        this.setExtInfo(FallConstants.FLD_EXT_VERSICHERUNGSNUMMER, value);
    }

    public List<IEncounter> getEncounters() {
        CoreModelServiceHolder.get().refresh((Identifiable)this);
        return ((Fall)this.getEntity()).getConsultations().parallelStream().filter(f -> !f.isDeleted()).map(f -> ModelUtil.getAdapter((EntityWithId)f, IEncounter.class, true)).collect(Collectors.toList());
    }

    public boolean isOpen() {
        return this.getDateTo() == null;
    }

    public String getLabel() {
        StringBuilder ret = new StringBuilder();
        if (!this.isOpen()) {
            ret.append(Messages.Fall_CLOSED);
        }
        String ges = this.getBillingSystem().getName();
        ret.append(ges).append(": ").append(this.getReason()).append(" - ");
        ret.append(this.getDescription()).append("(");
        LocalDate dateTo = this.getDateTo();
        ret.append(TimeUtil.formatSafe((LocalDate)this.getDateFrom())).append("-").append(dateTo == null ? Messages.Fall_Open : TimeUtil.formatSafe((LocalDate)dateTo)).append(")");
        return ret.toString();
    }

    public LocalDate getBillingProposalDate() {
        String proposalDateString = ((Fall)this.getEntity()).getBetriebsNummer();
        if (proposalDateString != null && !proposalDateString.isEmpty()) {
            return ModelUtil.toLocalDate(proposalDateString);
        }
        return null;
    }

    public void setBillingProposalDate(LocalDate value) {
        if (value != null) {
            ((Fall)this.getEntityMarkDirty()).setBetriebsNummer(ModelUtil.toString(value));
        } else {
            ((Fall)this.getEntityMarkDirty()).setBetriebsNummer(null);
        }
    }
}

