/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model;

import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.ISickCertificate;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.test.AbstractTest;
import java.io.IOException;
import java.time.LocalDate;
import java.util.Optional;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SickCertificateTest
extends AbstractTest {
    private IPatient patient1;

    @Before
    public void before() {
        super.before();
        this.patient1 = (IPatient)this.coreModelService.create(IPatient.class);
        this.patient1.setDescription1("test patient 1");
        this.coreModelService.save((Identifiable)this.patient1);
    }

    @After
    public void after() {
        this.coreModelService.remove((Identifiable)this.patient1);
        super.after();
    }

    @Test
    public void create() throws IOException {
        ISickCertificate certificate = (ISickCertificate)this.coreModelService.create(ISickCertificate.class);
        Assert.assertNotNull((Object)certificate);
        Assert.assertTrue((boolean)(certificate instanceof ISickCertificate));
        certificate.setPatient(this.patient1);
        certificate.setPercent(23);
        certificate.setDate(LocalDate.of(2000, 1, 1));
        certificate.setStart(LocalDate.of(2000, 1, 2));
        certificate.setEnd(LocalDate.of(2000, 1, 5));
        certificate.setReason("is sick");
        certificate.setNote("test");
        this.coreModelService.save((Identifiable)certificate);
        Optional loadedCertificate = this.coreModelService.load(certificate.getId(), ISickCertificate.class);
        Assert.assertTrue((boolean)loadedCertificate.isPresent());
        Assert.assertEquals((Object)this.patient1, (Object)((ISickCertificate)loadedCertificate.get()).getPatient());
        Assert.assertFalse((certificate == loadedCertificate.get() ? 1 : 0) != 0);
        Assert.assertEquals((Object)certificate, loadedCertificate.get());
        Assert.assertEquals((Object)certificate.getNote(), (Object)((ISickCertificate)loadedCertificate.get()).getNote());
        this.coreModelService.remove((Identifiable)certificate);
    }
}

