/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model;

import ch.elexis.core.model.IAccountTransaction;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.INamedQuery;
import ch.elexis.core.test.AbstractTest;
import ch.rgw.tools.Money;
import java.time.LocalDate;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AccountTransactionTest
extends AbstractTest {
    @Before
    public void before() {
        super.before();
        this.createPatient();
    }

    @After
    public void after() {
        super.after();
    }

    @Test
    public void createAndCalculateBalance() {
        IAccountTransaction accountTransaction = (IAccountTransaction)this.coreModelService.create(IAccountTransaction.class);
        accountTransaction.setPatient(this.patient);
        accountTransaction.setAmount(new Money(-300));
        accountTransaction.setDate(LocalDate.now().minusDays(5L));
        this.coreModelService.save((Identifiable)accountTransaction);
        IAccountTransaction accountTransaction2 = (IAccountTransaction)this.coreModelService.create(IAccountTransaction.class);
        accountTransaction2.setPatient(this.patient);
        accountTransaction2.setAmount(new Money(200));
        accountTransaction2.setDate(LocalDate.now());
        this.coreModelService.save((Identifiable)accountTransaction2);
        INamedQuery namedQuery = this.coreModelService.getNamedQuery(Number.class, IAccountTransaction.class, true, new String[]{"balance.patient"});
        Assert.assertNotNull((Object)namedQuery);
        List executeWithParameters = namedQuery.executeWithParameters(namedQuery.getParameterMap(new Object[]{"patient", this.patient}));
        Assert.assertEquals((Object)Long.valueOf("-100"), (Object)((Number)executeWithParameters.get(0)).longValue());
        this.coreModelService.remove((Identifiable)accountTransaction);
        this.coreModelService.remove((Identifiable)accountTransaction2);
    }
}

