/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.mail;

import ch.elexis.core.mail.AttachmentsUtil;
import ch.elexis.core.model.IImage;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import com.google.gson.Gson;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.slf4j.LoggerFactory;

public class MailMessage
implements Serializable {
    private static final long serialVersionUID = 5874662524515670629L;
    private static Gson gson = new Gson();
    private String to;
    private String cc;
    private String subject;
    private String text;
    private String attachmentsString;
    private String documentsString;
    private List<String> imageStrings;

    public static MailMessage fromJson(Serializable serializable) {
        return (MailMessage)gson.fromJson(gson.toJson((Object)serializable), MailMessage.class);
    }

    public static MailMessage fromMap(Map map) {
        MailMessage mailMessage = new MailMessage();
        mailMessage.setSubject((String)map.get("subject"));
        mailMessage.setTo((String)map.get("to"));
        mailMessage.setCc((String)map.get("cc"));
        mailMessage.setText((String)map.get("text"));
        mailMessage.setDocuments((String)map.get("documentsString"));
        mailMessage.setAttachments((String)map.get("attachmentsString"));
        return mailMessage;
    }

    public MailMessage to(String to) {
        this.setTo(to);
        return this;
    }

    public MailMessage cc(String cc) {
        this.setCc(cc);
        return this;
    }

    public MailMessage subject(String subject) {
        this.setSubject(subject);
        return this;
    }

    public MailMessage text(String text) {
        this.setText(text);
        return this;
    }

    public String getTo() {
        return this.to;
    }

    public String getCc() {
        return this.cc;
    }

    public InternetAddress[] getToAddress() throws AddressException {
        if (StringUtils.isNotEmpty((CharSequence)this.getTo())) {
            return InternetAddress.parse((String)this.getTo());
        }
        return new InternetAddress[0];
    }

    public InternetAddress[] getCcAddress() throws AddressException {
        if (StringUtils.isNotEmpty((CharSequence)this.getCc())) {
            return InternetAddress.parse((String)this.getCc());
        }
        return new InternetAddress[0];
    }

    public void setTo(String to) {
        this.to = to;
    }

    public void setCc(String cc) {
        this.cc = cc;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getText() {
        return this.text;
    }

    public String getHtmlText() {
        return this.text.replace("\n", "<br />\n");
    }

    public void setText(String text) {
        this.text = text;
        this.parseImage();
    }

    private void parseImage() {
        if (StringUtils.isNotEmpty((CharSequence)this.text) && this.text.indexOf("<img src=\"") != -1) {
            this.imageStrings = Jsoup.parse((String)this.text).select("img[src]").stream().map(e -> e.attr("src")).filter(s -> StringUtils.isNotBlank((CharSequence)s)).toList();
            this.imageStrings.forEach(s -> {
                if (!this.loadImage((String)s).isPresent()) {
                    LoggerFactory.getLogger(this.getClass()).warn("Image for [" + s + "] not found");
                }
            });
        }
    }

    public boolean hasAttachments() {
        return StringUtils.isNotBlank((CharSequence)this.documentsString) || StringUtils.isNotBlank((CharSequence)this.attachmentsString);
    }

    public List<File> getAttachments() {
        Object attachmentFilesString = this.attachmentsString;
        if (StringUtils.isNotBlank((CharSequence)attachmentFilesString) && !StringUtils.isBlank((CharSequence)this.documentsString)) {
            attachmentFilesString = (String)attachmentFilesString + ":::" + AttachmentsUtil.toAttachments(this.documentsString);
        } else if (!StringUtils.isBlank((CharSequence)this.documentsString)) {
            attachmentFilesString = AttachmentsUtil.toAttachments(this.documentsString);
        }
        return AttachmentsUtil.getAttachmentsFiles((String)attachmentFilesString);
    }

    public void setAttachments(String attachments) {
        this.attachmentsString = attachments;
    }

    public String getAttachmentsString() {
        return this.attachmentsString;
    }

    public void setDocuments(String documents) {
        this.documentsString = documents;
    }

    public String getDocumentsString() {
        return this.documentsString;
    }

    public boolean hasImage() {
        return this.imageStrings != null && !this.imageStrings.isEmpty();
    }

    private Optional<IImage> loadImage(String imageString) {
        Optional value;
        Optional ret = Optional.empty();
        IQuery query = CoreModelServiceHolder.get().getQuery(IImage.class);
        query.and("prefix", IQuery.COMPARATOR.EQUALS, (Object)"ch.elexis.core.mail");
        query.and("title", IQuery.COMPARATOR.LIKE, (Object)(this.getImageContentId(imageString) + "%"));
        ret = query.executeSingleResult();
        if (ret.isEmpty() && (value = ContextServiceHolder.get().getNamed("ch.elexis.core.mail.image." + this.getImageContentId(imageString))).isPresent() && value.get() instanceof IImage) {
            ret = value;
        }
        return ret;
    }

    public List<String> getImageStrings() {
        return this.imageStrings;
    }

    public File getImage(String imageString) {
        Optional<IImage> image = this.loadImage(imageString);
        if (image.isPresent()) {
            return AttachmentsUtil.getAttachmentsFile(image.get());
        }
        return null;
    }

    public String getImageContentId(String imageString) {
        return imageString.substring(imageString.indexOf("cid:") + "cid:".length(), imageString.length());
    }
}

