/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.jpa.entities.converter;

import ch.elexis.core.model.esr.ESRCode;
import jakarta.persistence.AttributeConverter;
import jakarta.persistence.Converter;

@Converter
public class ERSCodeTypeConverter
implements AttributeConverter<ESRCode, String> {
    public String convertToDatabaseColumn(ESRCode attribute) {
        if (attribute != null) {
            return Integer.toString(attribute.numericValue());
        }
        return null;
    }

    public ESRCode convertToEntityAttribute(String dbData) {
        String esrCodeString = dbData;
        int typeNum = -1;
        if (esrCodeString != null && !esrCodeString.isEmpty()) {
            try {
                typeNum = Integer.parseInt(esrCodeString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return ESRCode.byNumeric((int)typeNum);
    }
}

