/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.jpa.entities;

import ch.elexis.core.jpa.entities.AbstractEntityWithId;
import ch.elexis.core.jpa.entities.EntityWithDeleted;
import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.entities.Invoice;
import ch.elexis.core.jpa.entities.Kontakt;
import ch.elexis.core.jpa.entities.converter.BooleanCharacterConverterSafe;
import ch.elexis.core.jpa.entities.converter.ERSCodeTypeConverter;
import ch.elexis.core.jpa.entities.converter.ERSRejectCodeTypeConverter;
import ch.elexis.core.jpa.entities.converter.IntegerStringConverter;
import ch.elexis.core.jpa.entities.listener.EntityWithIdListener;
import ch.elexis.core.model.esr.ESRCode;
import ch.elexis.core.model.esr.ESRRejectCode;
import ch.elexis.core.model.util.ElexisIdGenerator;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.time.LocalDate;
import org.eclipse.persistence.annotations.Cache;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@Table(name="esrrecords")
@EntityListeners(value={EntityWithIdListener.class})
@Cache(expiry=15000)
public class EsrRecord
extends AbstractEntityWithId
implements EntityWithId,
EntityWithDeleted,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    protected Long lastupdate;
    @Id
    @Column(unique=true, nullable=false, length=25)
    private String id;
    @Column
    @Convert(converter=BooleanCharacterConverterSafe.class)
    protected boolean deleted;
    @Column(length=8)
    private LocalDate datum;
    @Column(length=8)
    private LocalDate eingelesen;
    @Column(length=8)
    private LocalDate verarbeitet;
    @Column(length=8)
    private LocalDate gutschrift;
    @Column(length=8)
    private LocalDate gebucht;
    @Convert(converter=IntegerStringConverter.class)
    private int betraginrp;
    @Column(length=3)
    @Convert(converter=ERSCodeTypeConverter.class)
    private ESRCode code;
    @Column(length=3)
    @Convert(converter=ERSRejectCodeTypeConverter.class)
    private ESRRejectCode rejectcode;
    @Column(length=4)
    private String kosten;
    @ManyToOne
    @JoinColumn(name="rechnungsid")
    private Invoice rechnung;
    @ManyToOne
    @JoinColumn(name="patientid")
    private Kontakt patient;
    @ManyToOne
    @JoinColumn(name="mandantid")
    private Kontakt mandant;
    @Column(length=80)
    private String file;
    static final long serialVersionUID = 3364311498207049739L;

    public EsrRecord() {
        this.id = ElexisIdGenerator.generateId();
        this.deleted = false;
    }

    @Override
    public boolean isDeleted() {
        return this._persistence_get_deleted();
    }

    @Override
    public void setDeleted(boolean deleted) {
        this._persistence_set_deleted(deleted);
    }

    @Override
    public String getId() {
        return this._persistence_get_id();
    }

    @Override
    public void setId(String id) {
        this._persistence_set_id(id);
    }

    @Override
    public Long getLastupdate() {
        return this._persistence_get_lastupdate();
    }

    @Override
    public void setLastupdate(Long lastupdate) {
        this._persistence_set_lastupdate(lastupdate);
    }

    public LocalDate getDatum() {
        return this._persistence_get_datum();
    }

    public void setDatum(LocalDate value) {
        this._persistence_set_datum(value);
    }

    public LocalDate getEingelesen() {
        return this._persistence_get_eingelesen();
    }

    public void setEingelesen(LocalDate eingelesen) {
        this._persistence_set_eingelesen(eingelesen);
    }

    public LocalDate getVerarbeitet() {
        return this._persistence_get_verarbeitet();
    }

    public void setVerarbeitet(LocalDate verarbeitet) {
        this._persistence_set_verarbeitet(verarbeitet);
    }

    public LocalDate getGutschrift() {
        return this._persistence_get_gutschrift();
    }

    public void setGutschrift(LocalDate gutschrift) {
        this._persistence_set_gutschrift(gutschrift);
    }

    public LocalDate getGebucht() {
        return this._persistence_get_gebucht();
    }

    public void setGebucht(LocalDate gebucht) {
        this._persistence_set_gebucht(gebucht);
    }

    public Invoice getRechnung() {
        return this._persistence_get_rechnung();
    }

    public void setRechnung(Invoice rechnung) {
        this._persistence_set_rechnung(rechnung);
    }

    public Kontakt getPatient() {
        return this._persistence_get_patient();
    }

    public void setPatient(Kontakt patient) {
        this._persistence_set_patient(patient);
    }

    public Kontakt getMandant() {
        return this._persistence_get_mandant();
    }

    public void setMandant(Kontakt mandant) {
        this._persistence_set_mandant(mandant);
    }

    public int getBetraginrp() {
        return this._persistence_get_betraginrp();
    }

    public void setBetraginrp(int betraginrp) {
        this._persistence_set_betraginrp(betraginrp);
    }

    public ESRCode getCode() {
        return this._persistence_get_code();
    }

    public ESRRejectCode getRejectcode() {
        return this._persistence_get_rejectcode();
    }

    public String getFile() {
        return this._persistence_get_file();
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new EsrRecord(persistenceObject);
    }

    public EsrRecord(PersistenceObject persistenceObject) {
        super(persistenceObject);
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "datum") {
            return this.datum;
        }
        if (string == "verarbeitet") {
            return this.verarbeitet;
        }
        if (string == "rechnung") {
            return this.rechnung;
        }
        if (string == "code") {
            return this.code;
        }
        if (string == "betraginrp") {
            return this.betraginrp;
        }
        if (string == "kosten") {
            return this.kosten;
        }
        if (string == "gebucht") {
            return this.gebucht;
        }
        if (string == "rejectcode") {
            return this.rejectcode;
        }
        if (string == "gutschrift") {
            return this.gutschrift;
        }
        if (string == "eingelesen") {
            return this.eingelesen;
        }
        if (string == "deleted") {
            return this.deleted;
        }
        if (string == "file") {
            return this.file;
        }
        if (string == "patient") {
            return this.patient;
        }
        if (string == "mandant") {
            return this.mandant;
        }
        if (string == "lastupdate") {
            return this.lastupdate;
        }
        if (string == "id") {
            return this.id;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "datum") {
            this.datum = (LocalDate)object;
            return;
        }
        if (string == "verarbeitet") {
            this.verarbeitet = (LocalDate)object;
            return;
        }
        if (string == "rechnung") {
            this.rechnung = (Invoice)object;
            return;
        }
        if (string == "code") {
            this.code = (ESRCode)object;
            return;
        }
        if (string == "betraginrp") {
            this.betraginrp = (Integer)object;
            return;
        }
        if (string == "kosten") {
            this.kosten = (String)object;
            return;
        }
        if (string == "gebucht") {
            this.gebucht = (LocalDate)object;
            return;
        }
        if (string == "rejectcode") {
            this.rejectcode = (ESRRejectCode)object;
            return;
        }
        if (string == "gutschrift") {
            this.gutschrift = (LocalDate)object;
            return;
        }
        if (string == "eingelesen") {
            this.eingelesen = (LocalDate)object;
            return;
        }
        if (string == "deleted") {
            this.deleted = (Boolean)object;
            return;
        }
        if (string == "file") {
            this.file = (String)object;
            return;
        }
        if (string == "patient") {
            this.patient = (Kontakt)object;
            return;
        }
        if (string == "mandant") {
            this.mandant = (Kontakt)object;
            return;
        }
        if (string == "lastupdate") {
            this.lastupdate = (Long)object;
            return;
        }
        if (string == "id") {
            this.id = (String)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public LocalDate _persistence_get_datum() {
        this._persistence_checkFetched("datum");
        return this.datum;
    }

    public void _persistence_set_datum(LocalDate localDate) {
        this._persistence_checkFetchedForSet("datum");
        this._persistence_propertyChange("datum", this.datum, localDate);
        this.datum = localDate;
    }

    public LocalDate _persistence_get_verarbeitet() {
        this._persistence_checkFetched("verarbeitet");
        return this.verarbeitet;
    }

    public void _persistence_set_verarbeitet(LocalDate localDate) {
        this._persistence_checkFetchedForSet("verarbeitet");
        this._persistence_propertyChange("verarbeitet", this.verarbeitet, localDate);
        this.verarbeitet = localDate;
    }

    public Invoice _persistence_get_rechnung() {
        this._persistence_checkFetched("rechnung");
        return this.rechnung;
    }

    public void _persistence_set_rechnung(Invoice invoice) {
        this._persistence_checkFetchedForSet("rechnung");
        this._persistence_propertyChange("rechnung", this.rechnung, invoice);
        this.rechnung = invoice;
    }

    public ESRCode _persistence_get_code() {
        this._persistence_checkFetched("code");
        return this.code;
    }

    public void _persistence_set_code(ESRCode eSRCode) {
        this._persistence_checkFetchedForSet("code");
        this._persistence_propertyChange("code", this.code, eSRCode);
        this.code = eSRCode;
    }

    public int _persistence_get_betraginrp() {
        this._persistence_checkFetched("betraginrp");
        return this.betraginrp;
    }

    public void _persistence_set_betraginrp(int n) {
        this._persistence_checkFetchedForSet("betraginrp");
        this._persistence_propertyChange("betraginrp", new Integer(this.betraginrp), new Integer(n));
        this.betraginrp = n;
    }

    public String _persistence_get_kosten() {
        this._persistence_checkFetched("kosten");
        return this.kosten;
    }

    public void _persistence_set_kosten(String string) {
        this._persistence_checkFetchedForSet("kosten");
        this._persistence_propertyChange("kosten", this.kosten, string);
        this.kosten = string;
    }

    public LocalDate _persistence_get_gebucht() {
        this._persistence_checkFetched("gebucht");
        return this.gebucht;
    }

    public void _persistence_set_gebucht(LocalDate localDate) {
        this._persistence_checkFetchedForSet("gebucht");
        this._persistence_propertyChange("gebucht", this.gebucht, localDate);
        this.gebucht = localDate;
    }

    public ESRRejectCode _persistence_get_rejectcode() {
        this._persistence_checkFetched("rejectcode");
        return this.rejectcode;
    }

    public void _persistence_set_rejectcode(ESRRejectCode eSRRejectCode) {
        this._persistence_checkFetchedForSet("rejectcode");
        this._persistence_propertyChange("rejectcode", this.rejectcode, eSRRejectCode);
        this.rejectcode = eSRRejectCode;
    }

    public LocalDate _persistence_get_gutschrift() {
        this._persistence_checkFetched("gutschrift");
        return this.gutschrift;
    }

    public void _persistence_set_gutschrift(LocalDate localDate) {
        this._persistence_checkFetchedForSet("gutschrift");
        this._persistence_propertyChange("gutschrift", this.gutschrift, localDate);
        this.gutschrift = localDate;
    }

    public LocalDate _persistence_get_eingelesen() {
        this._persistence_checkFetched("eingelesen");
        return this.eingelesen;
    }

    public void _persistence_set_eingelesen(LocalDate localDate) {
        this._persistence_checkFetchedForSet("eingelesen");
        this._persistence_propertyChange("eingelesen", this.eingelesen, localDate);
        this.eingelesen = localDate;
    }

    public boolean _persistence_get_deleted() {
        this._persistence_checkFetched("deleted");
        return this.deleted;
    }

    public void _persistence_set_deleted(boolean bl) {
        this._persistence_checkFetchedForSet("deleted");
        this._persistence_propertyChange("deleted", new Boolean(this.deleted), new Boolean(bl));
        this.deleted = bl;
    }

    public String _persistence_get_file() {
        this._persistence_checkFetched("file");
        return this.file;
    }

    public void _persistence_set_file(String string) {
        this._persistence_checkFetchedForSet("file");
        this._persistence_propertyChange("file", this.file, string);
        this.file = string;
    }

    public Kontakt _persistence_get_patient() {
        this._persistence_checkFetched("patient");
        return this.patient;
    }

    public void _persistence_set_patient(Kontakt kontakt) {
        this._persistence_checkFetchedForSet("patient");
        this._persistence_propertyChange("patient", this.patient, kontakt);
        this.patient = kontakt;
    }

    public Kontakt _persistence_get_mandant() {
        this._persistence_checkFetched("mandant");
        return this.mandant;
    }

    public void _persistence_set_mandant(Kontakt kontakt) {
        this._persistence_checkFetchedForSet("mandant");
        this._persistence_propertyChange("mandant", this.mandant, kontakt);
        this.mandant = kontakt;
    }

    public Long _persistence_get_lastupdate() {
        this._persistence_checkFetched("lastupdate");
        return this.lastupdate;
    }

    public void _persistence_set_lastupdate(Long l) {
        this._persistence_checkFetchedForSet("lastupdate");
        this._persistence_propertyChange("lastupdate", this.lastupdate, l);
        this.lastupdate = l;
    }

    public String _persistence_get_id() {
        this._persistence_checkFetched("id");
        return this.id;
    }

    public void _persistence_set_id(String string) {
        this._persistence_checkFetchedForSet("id");
        this._persistence_propertyChange("id", this.id, string);
        this.id = string;
    }
}

