/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.importer.div.importers;

import ch.elexis.core.importer.div.importers.Messages;
import ch.rgw.tools.TimeTool;
import java.io.FileInputStream;
import java.io.InputStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.usermodel.WorkbookProvider;
import org.apache.poi.xssf.usermodel.XSSFWorkbookFactory;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.slf4j.LoggerFactory;

@Component
public class ExcelWrapper {
    private Class<?>[] types;
    private Sheet sheet;

    @Activate
    public void activate() {
        WorkbookFactory.addProvider((WorkbookProvider)new XSSFWorkbookFactory());
    }

    @Deprecated
    public boolean load(String file, int page) {
        try {
            Workbook wb = WorkbookFactory.create((InputStream)new FileInputStream(file));
            this.sheet = wb.getSheetAt(page);
            return true;
        }
        catch (Exception ex) {
            LoggerFactory.getLogger(this.getClass()).error("Error loading from input", (Throwable)ex);
            return false;
        }
    }

    public boolean load(InputStream inputStream, int page) {
        try {
            Workbook wb = WorkbookFactory.create((InputStream)inputStream);
            this.sheet = wb.getSheetAt(page);
            return true;
        }
        catch (Exception ex) {
            LoggerFactory.getLogger(this.getClass()).error("Error loading from input", (Throwable)ex);
            return false;
        }
    }

    public void setFieldTypes(Class<?>[] types) {
        this.types = types;
    }

    public List<String> getRow(int rowNr) {
        Row row = this.sheet.getRow(rowNr);
        if (row == null) {
            return null;
        }
        ArrayList<String> ret = new ArrayList<String>();
        short first = 0;
        short last = 100;
        if (this.types != null) {
            last = (short)this.types.length;
        } else {
            first = row.getFirstCellNum();
            last = row.getLastCellNum();
        }
        short i = first;
        while (i < last) {
            Cell cell = row.getCell((int)i);
            if (cell != null) {
                switch (cell.getCellType()) {
                    case BLANK: {
                        ret.add("");
                        break;
                    }
                    case BOOLEAN: {
                        ret.add(Boolean.toString(cell.getBooleanCellValue()));
                        break;
                    }
                    case NUMERIC: {
                        if (this.types != null) {
                            if (this.types[i].equals(Integer.class)) {
                                ret.add(Long.toString(Math.round(cell.getNumericCellValue())));
                                break;
                            }
                            if (this.types[i].equals(TimeTool.class)) {
                                Date date = cell.getDateCellValue();
                                if (date != null) {
                                    TimeTool tt = new TimeTool(date.getTime());
                                    ret.add(tt.toString(5));
                                    break;
                                }
                                ret.add("");
                                break;
                            }
                            if (this.types[i].equals(Double.class)) {
                                ret.add(Double.toString(cell.getNumericCellValue()));
                                break;
                            }
                            if (this.types[i].equals(String.class)) {
                                double cv = cell.getNumericCellValue();
                                if (cv == (double)((long)cv)) {
                                    ret.add(String.format("%d", (long)cv));
                                    break;
                                }
                                ret.add(String.format("%s", cv));
                                break;
                            }
                            double cv = cell.getNumericCellValue();
                            String r = NumberFormat.getNumberInstance().format(cv);
                            ret.add(r);
                            break;
                        }
                    }
                    case FORMULA: {
                        ret.add(Double.toString(cell.getNumericCellValue()));
                        break;
                    }
                    case STRING: {
                        ret.add(cell.toString());
                        break;
                    }
                    default: {
                        ret.add(Messages.ExcelWrapper_ErrorUnknownCellType);
                        break;
                    }
                }
            } else {
                ret.add("");
            }
            i = (short)(i + 1);
        }
        return ret;
    }

    public int getFirstRow() {
        return this.sheet.getFirstRowNum();
    }

    public int getLastRow() {
        return this.sheet.getLastRowNum();
    }

    public static String getSafe(List<String> row, int col) {
        if (row.size() > col) {
            return row.get(col);
        }
        return "";
    }
}

