/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.internal;

import ch.elexis.core.findings.util.internal.FindingsFormat;
import ch.elexis.core.findings.util.internal.JsonStructuralFeature;
import ch.elexis.core.findings.util.internal.JsonStructuralFeatureTransformation;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class FindingsFormat20
extends FindingsFormat {
    public FindingsFormat20() {
        HashMap<String, JsonStructuralFeature> conditionFields = new HashMap<String, JsonStructuralFeature>();
        conditionFields.put("resourceType", new JsonStructuralFeature("resourceType", JsonStructuralFeature.Type.PRIMITIVE));
        conditionFields.put("id", new JsonStructuralFeature("id", JsonStructuralFeature.Type.PRIMITIVE));
        conditionFields.put("text", new JsonStructuralFeature("text", JsonStructuralFeature.Type.OBJECT));
        conditionFields.put("category", new JsonStructuralFeature("category", JsonStructuralFeature.Type.OBJECT));
        conditionFields.put("code", new JsonStructuralFeature("code", JsonStructuralFeature.Type.OBJECT));
        conditionFields.put("subject", new JsonStructuralFeature("subject", JsonStructuralFeature.Type.OBJECT));
        conditionFields.put("dateRecorded", new JsonStructuralFeature("dateRecorded", JsonStructuralFeature.Type.PRIMITIVE));
        this.resourceFieldsMap.put("Condition", conditionFields);
        HashMap<String, JsonStructuralFeature> encounterFields = new HashMap<String, JsonStructuralFeature>();
        encounterFields.put("resourceType", new JsonStructuralFeature("resourceType", JsonStructuralFeature.Type.PRIMITIVE));
        encounterFields.put("id", new JsonStructuralFeature("id", JsonStructuralFeature.Type.PRIMITIVE));
        encounterFields.put("text", new JsonStructuralFeature("text", JsonStructuralFeature.Type.OBJECT));
        encounterFields.put("indication", new JsonStructuralFeature("indication", JsonStructuralFeature.Type.ARRAY));
        encounterFields.put("patient", new JsonStructuralFeature("patient", JsonStructuralFeature.Type.OBJECT));
        this.resourceFieldsMap.put("Encounter", encounterFields);
        HashMap<String, JsonStructuralFeature> procedureRequestFields = new HashMap<String, JsonStructuralFeature>();
        procedureRequestFields.put("resourceType", new JsonStructuralFeature("resourceType", JsonStructuralFeature.Type.PRIMITIVE));
        procedureRequestFields.put("id", new JsonStructuralFeature("id", JsonStructuralFeature.Type.PRIMITIVE));
        procedureRequestFields.put("text", new JsonStructuralFeature("text", JsonStructuralFeature.Type.OBJECT));
        procedureRequestFields.put("encounter", new JsonStructuralFeature("encounter", JsonStructuralFeature.Type.OBJECT));
        this.resourceFieldsMap.put("ProcedureRequest", procedureRequestFields);
    }

    @Override
    public int isFindingsFormat(String rawContent) {
        JsonObject jsonObject = this.getJsonObject(rawContent);
        JsonElement resourceType = jsonObject.get("resourceType");
        return this.checkFindingsFormatProperties(resourceType, jsonObject);
    }

    private int checkFindingsFormatProperties(JsonElement resourceType, JsonObject jsonObject) {
        switch (resourceType.getAsString()) {
            case "Condition": {
                return this.checkFields((Map)this.resourceFieldsMap.get("Condition"), jsonObject);
            }
            case "Encounter": {
                return this.checkFields((Map)this.resourceFieldsMap.get("Encounter"), jsonObject);
            }
            case "ProcedureRequest": {
                return this.checkFields((Map)this.resourceFieldsMap.get("ProcedureRequest"), jsonObject);
            }
        }
        return 0;
    }

    @Override
    public Optional<String> convertToCurrentFormat(String rawContent) {
        JsonObject jsonObject = this.getJsonObject(rawContent);
        JsonElement resourceType = jsonObject.get("resourceType");
        return this.convertToCurrentFormat(resourceType, jsonObject);
    }

    private Optional<String> convertToCurrentFormat(JsonElement resourceType, JsonObject jsonObject) {
        HashMap<String, JsonStructuralFeatureTransformation> conditionTransformations = new HashMap<String, JsonStructuralFeatureTransformation>();
        conditionTransformations.put("dateRecorded", new JsonStructuralFeatureTransformation(){

            @Override
            public JsonElement transformValue(JsonElement element) {
                return element;
            }

            @Override
            public String transformKey(String key) {
                return "assertedDate";
            }
        });
        conditionTransformations.put("category", new JsonStructuralFeatureTransformation(){

            @Override
            public String transformKey(String key) {
                return key;
            }

            @Override
            public JsonElement transformValue(JsonElement element) {
                JsonObject category = new JsonObject();
                JsonArray coding = new JsonArray();
                for (Map.Entry entry : ((JsonObject)element).entrySet()) {
                    if (!((String)entry.getKey()).equals("coding") || !((JsonElement)entry.getValue()).isJsonArray()) continue;
                    JsonArray existingCoding = (JsonArray)entry.getValue();
                    for (JsonElement jsonElement : existingCoding) {
                        if (jsonElement.isJsonObject() && ((JsonObject)jsonElement).get("system").getAsString().equals("http://hl7.org/fhir/condition-category") && ((JsonObject)jsonElement).get("code").getAsString().equals("diagnosis")) {
                            JsonObject newCoding = new JsonObject();
                            newCoding.add("system", (JsonElement)new JsonPrimitive("http://hl7.org/fhir/condition-category"));
                            newCoding.add("code", (JsonElement)new JsonPrimitive("problem-list-item"));
                            newCoding.add("display", (JsonElement)new JsonPrimitive("Problem List Item"));
                            coding.add((JsonElement)newCoding);
                            continue;
                        }
                        coding.add(jsonElement);
                    }
                }
                category.add("coding", (JsonElement)coding);
                JsonArray ret = new JsonArray();
                ret.add((JsonElement)category);
                return ret;
            }
        });
        HashMap<String, JsonStructuralFeatureTransformation> encounterTransformations = new HashMap<String, JsonStructuralFeatureTransformation>();
        encounterTransformations.put("indication", new JsonStructuralFeatureTransformation(){

            @Override
            public JsonElement transformValue(JsonElement element) {
                JsonArray diagnosisArray = new JsonArray();
                if (element instanceof JsonArray) {
                    JsonArray referenceArray = (JsonArray)element;
                    for (JsonElement jsonElement : referenceArray) {
                        JsonObject condition = new JsonObject();
                        condition.add("condition", jsonElement);
                        diagnosisArray.add((JsonElement)condition);
                    }
                }
                return diagnosisArray;
            }

            @Override
            public String transformKey(String key) {
                return "diagnosis";
            }
        });
        encounterTransformations.put("patient", new JsonStructuralFeatureTransformation(){

            @Override
            public JsonElement transformValue(JsonElement element) {
                return element;
            }

            @Override
            public String transformKey(String key) {
                return "subject";
            }
        });
        HashMap<String, JsonStructuralFeatureTransformation> procedureRequestTransformations = new HashMap<String, JsonStructuralFeatureTransformation>();
        procedureRequestTransformations.put("encounter", new JsonStructuralFeatureTransformation(){

            @Override
            public JsonElement transformValue(JsonElement element) {
                return element;
            }

            @Override
            public String transformKey(String key) {
                return "context";
            }
        });
        switch (resourceType.getAsString()) {
            case "Condition": {
                return this.convert(conditionTransformations, jsonObject);
            }
            case "Encounter": {
                return this.convert(encounterTransformations, jsonObject);
            }
            case "ProcedureRequest": {
                return this.convert(procedureRequestTransformations, jsonObject);
            }
        }
        return Optional.empty();
    }
}

