/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.transformer.mapper;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ch.elexis.core.findings.util.fhir.transformer.helper.FhirUtil;
import ch.elexis.core.findings.util.fhir.transformer.mapper.IdentifiableDomainResourceAttributeMapper;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IReminder;
import ch.elexis.core.model.IUserGroup;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.issue.Priority;
import ch.elexis.core.model.issue.ProcessStatus;
import ch.elexis.core.model.issue.Type;
import ch.elexis.core.model.issue.Visibility;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.Annotation;
import org.hl7.fhir.r4.model.CareTeam;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.Period;
import org.hl7.fhir.r4.model.Person;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Task;

public class IReminderTaskAttributeMapper
implements IdentifiableDomainResourceAttributeMapper<IReminder, Task> {
    private IModelService modelService;

    public IReminderTaskAttributeMapper(IModelService modelService) {
        this.modelService = modelService;
    }

    @Override
    public void elexisToFhir(IReminder source, Task target, SummaryEnum summaryEnum, Set<Include> includes) {
        Reference practitionerReference;
        FhirUtil.setVersionedIdPartLastUpdatedMeta(Task.class, (DomainResource)target, (Identifiable)source);
        target.setIntent(Task.TaskIntent.UNKNOWN);
        target.setStatus(this.getTaskStatus(source));
        target.setPriority(this.getTaskPriority(source));
        target.getCode().addCoding(this.getVisibilityCoding(source));
        target.getCode().addCoding(this.getTypeCoding(source));
        target.setDescription(source.getSubject());
        if (StringUtils.isNotBlank((CharSequence)source.getMessage())) {
            target.addNote(this.getMessageNote(source));
        }
        if (source.getDue() != null) {
            target.setExecutionPeriod(this.getExecutionPeriod(source));
        }
        if (!source.getResponsible().isEmpty()) {
            IContact contact = (IContact)source.getResponsible().get(0);
            if (contact != null) {
                if (contact.isOrganization()) {
                    Reference organizationReference = new Reference((IIdType)new IdDt(Organization.class.getSimpleName(), contact.getId()));
                    target.setOwner(organizationReference);
                } else if (contact.isUser()) {
                    Reference practitionerReference2 = new Reference((IIdType)new IdDt(Practitioner.class.getSimpleName(), contact.getId()));
                    target.setOwner(practitionerReference2);
                } else {
                    Reference personReference = new Reference((IIdType)new IdDt(Person.class.getSimpleName(), contact.getId()));
                    target.setOwner(personReference);
                }
            }
        } else if (source.getGroup() != null) {
            IUserGroup userGroup = source.getGroup();
            Reference groupReference = new Reference((IIdType)new IdDt(CareTeam.class.getSimpleName(), userGroup.getId()));
            target.setOwner(groupReference);
        } else if (source.isResponsibleAll()) {
            Reference groupReference = new Reference((IIdType)new IdDt(CareTeam.class.getSimpleName(), "ALL"));
            target.setOwner(groupReference);
        }
        if (source.getContact() != null) {
            if (source.getContact().isPatient()) {
                Reference patientReference = new Reference((IIdType)new IdDt(Patient.class.getSimpleName(), source.getContact().getId()));
                target.setFor(patientReference);
            } else if (source.getContact().isUser()) {
                practitionerReference = new Reference((IIdType)new IdDt(Practitioner.class.getSimpleName(), source.getContact().getId()));
                target.setFor(practitionerReference);
            }
        }
        if (source.getCreator() != null && source.getCreator().isUser()) {
            practitionerReference = new Reference((IIdType)new IdDt(Practitioner.class.getSimpleName(), source.getCreator().getId()));
            target.setRequester(practitionerReference);
        }
    }

    @Override
    public void fhirToElexis(Task source, IReminder target) {
        Optional requesterContact;
        target.setStatus(this.getProcessStatus(source));
        target.setPriority(this.getPriority(source));
        target.setVisibility(this.getVisibility(source));
        target.setType(this.getType(source));
        target.setSubject(source.getDescription());
        if (source.hasNote()) {
            target.setMessage(this.getMessage(source));
        }
        if (source.hasExecutionPeriod() && source.getExecutionPeriod().hasEnd()) {
            target.setDue(LocalDate.ofInstant(source.getExecutionPeriod().getEnd().toInstant(), ZoneId.systemDefault()));
        } else {
            target.setDue(null);
        }
        if (source.hasOwner()) {
            if (CareTeam.class.getSimpleName().equals(source.getOwner().getReferenceElement().getResourceType())) {
                if ("all".equalsIgnoreCase(source.getOwner().getReferenceElement().getIdPart())) {
                    target.setGroup(null);
                    target.getResponsible().forEach(c -> target.removeResponsible(c));
                    target.setResponsibleAll(true);
                } else {
                    Optional ownerGroup = CoreModelServiceHolder.get().load(source.getOwner().getReferenceElement().getIdPart(), IUserGroup.class);
                    if (ownerGroup.isPresent()) {
                        target.setResponsibleAll(false);
                        target.getResponsible().forEach(c -> target.removeResponsible(c));
                        target.setGroup((IUserGroup)ownerGroup.get());
                    }
                }
            } else {
                Optional ownerContact = CoreModelServiceHolder.get().load(source.getOwner().getReferenceElement().getIdPart(), IContact.class);
                if (ownerContact.isPresent()) {
                    target.setResponsibleAll(false);
                    target.setGroup(null);
                    target.getResponsible().forEach(c -> target.removeResponsible(c));
                    target.addResponsible((IContact)ownerContact.get());
                }
            }
        }
        if (source.hasFor()) {
            Optional forContact = CoreModelServiceHolder.get().load(source.getFor().getReferenceElement().getIdPart(), IContact.class);
            if (forContact.isPresent()) {
                target.setContact((IContact)forContact.get());
            }
        } else {
            target.setContact(null);
        }
        if (source.hasRequester() && Practitioner.class.getSimpleName().equals(source.getRequester().getType()) && (requesterContact = CoreModelServiceHolder.get().load(source.getFor().getReferenceElement().getIdPart(), IContact.class)).isPresent()) {
            target.setCreator((IContact)requesterContact.get());
        }
    }

    private String getMessage(Task source) {
        return source.getNote().stream().map(n -> n.getText()).collect(Collectors.joining("\n\n"));
    }

    private Type getType(Task source) {
        Optional<String> typeCode;
        if (source.hasCode() && (typeCode = FhirUtil.getCodeFromCodingList("http://www.elexis.info/task/type", source.getCode().getCoding())).isPresent()) {
            return Type.valueOf((String)typeCode.get());
        }
        return Type.COMMON;
    }

    private Visibility getVisibility(Task source) {
        Optional<String> visibilityCode;
        if (source.hasCode() && (visibilityCode = FhirUtil.getCodeFromCodingList("http://www.elexis.info/task/visibility", source.getCode().getCoding())).isPresent()) {
            return Visibility.valueOf((String)visibilityCode.get());
        }
        return Visibility.ALWAYS;
    }

    private Task.TaskPriority getTaskPriority(IReminder source) {
        if (source.getPriority() != null) {
            switch (source.getPriority()) {
                case HIGH: {
                    return Task.TaskPriority.URGENT;
                }
                case MEDIUM: {
                    return Task.TaskPriority.ROUTINE;
                }
            }
        }
        return Task.TaskPriority.ROUTINE;
    }

    private Priority getPriority(Task source) {
        if (source.getPriority() != null) {
            switch (source.getPriority()) {
                case URGENT: 
                case ASAP: 
                case STAT: {
                    return Priority.HIGH;
                }
                case ROUTINE: {
                    return Priority.MEDIUM;
                }
            }
        }
        return Priority.MEDIUM;
    }

    private Task.TaskStatus getTaskStatus(IReminder source) {
        switch (source.getStatus()) {
            case CLOSED: {
                return Task.TaskStatus.COMPLETED;
            }
            case IN_PROGRESS: {
                return Task.TaskStatus.INPROGRESS;
            }
            case ON_HOLD: {
                return Task.TaskStatus.ONHOLD;
            }
            case OPEN: 
            case DUE: 
            case OVERDUE: {
                return Task.TaskStatus.ACCEPTED;
            }
        }
        return Task.TaskStatus.DRAFT;
    }

    private ProcessStatus getProcessStatus(Task source) {
        switch (source.getStatus()) {
            case DRAFT: 
            case REQUESTED: 
            case RECEIVED: 
            case ACCEPTED: 
            case READY: {
                return ProcessStatus.OPEN;
            }
            case REJECTED: 
            case CANCELLED: 
            case FAILED: 
            case COMPLETED: 
            case ENTEREDINERROR: {
                return ProcessStatus.CLOSED;
            }
            case INPROGRESS: {
                return ProcessStatus.IN_PROGRESS;
            }
            case ONHOLD: {
                return ProcessStatus.ON_HOLD;
            }
        }
        return ProcessStatus.OPEN;
    }

    private Coding getVisibilityCoding(IReminder source) {
        if (source.getVisibility() != null) {
            return new Coding("http://www.elexis.info/task/visibility", source.getVisibility().name(), source.getVisibility().getLocaleText());
        }
        return null;
    }

    private Coding getTypeCoding(IReminder source) {
        if (source.getType() != null) {
            return new Coding("http://www.elexis.info/task/type", source.getType().name(), source.getType().getLocaleText());
        }
        return null;
    }

    private Annotation getMessageNote(IReminder source) {
        Annotation ret = new Annotation();
        ret.setText(source.getMessage());
        return ret;
    }

    private Period getExecutionPeriod(IReminder source) {
        Period ret = new Period();
        ret.setEnd(Date.from(source.getDue().atStartOfDay(ZoneId.systemDefault()).toInstant()));
        return ret;
    }
}

