/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.transformer;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ch.elexis.core.findings.util.fhir.IFhirTransformer;
import ch.elexis.core.findings.util.fhir.transformer.helper.FhirUtil;
import ch.elexis.core.findings.util.fhir.transformer.mapper.IOrganizationOrganizationAttributeMapper;
import ch.elexis.core.model.IOrganization;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IUserService;
import ch.elexis.core.services.IXidService;
import java.util.Optional;
import java.util.Set;
import org.hl7.fhir.r4.model.Organization;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class OrganizationKontaktTransformer
implements IFhirTransformer<Organization, IOrganization> {
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService modelService;
    @Reference
    private IXidService xidService;
    @Reference
    private IUserService userService;
    private IOrganizationOrganizationAttributeMapper attributeMapper;

    @Activate
    public void activate() {
        this.attributeMapper = new IOrganizationOrganizationAttributeMapper(this.xidService);
    }

    @Override
    public Optional<Organization> getFhirObject(IOrganization localObject, SummaryEnum summaryEnum, Set<Include> includes) {
        Organization organization = new Organization();
        this.attributeMapper.elexisToFhir(localObject, organization, summaryEnum, includes);
        return Optional.of(organization);
    }

    @Override
    public Optional<IOrganization> getLocalObject(Organization fhirObject) {
        Optional<String> localId;
        if (fhirObject != null && fhirObject.getId() != null && (localId = FhirUtil.getLocalId(fhirObject.getId())).isPresent()) {
            return this.modelService.load(localId.get(), IOrganization.class);
        }
        return Optional.empty();
    }

    @Override
    public Optional<IOrganization> updateLocalObject(Organization fhirObject, IOrganization localObject) {
        this.attributeMapper.fhirToElexis(fhirObject, localObject);
        this.modelService.save((Identifiable)localObject);
        return Optional.of(localObject);
    }

    @Override
    public Optional<IOrganization> createLocalObject(Organization fhirObject) {
        IOrganization create = (IOrganization)this.modelService.create(IOrganization.class);
        this.attributeMapper.fhirToElexis(fhirObject, create);
        this.modelService.save((Identifiable)create);
        return Optional.of(create);
    }

    @Override
    public boolean matchesTypes(Class<?> fhirClazz, Class<?> localClazz) {
        return Organization.class.equals(fhirClazz) && IOrganization.class.equals(localClazz);
    }
}

