/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.transformer;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ch.elexis.core.findings.util.fhir.IFhirTransformer;
import ch.elexis.core.findings.util.fhir.transformer.helper.FhirUtil;
import ch.elexis.core.findings.util.fhir.transformer.mapper.IInvoiceInvoiceAttributeMapper;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.IInvoice;
import ch.elexis.core.services.IModelService;
import java.util.Optional;
import java.util.Set;
import org.hl7.fhir.r4.model.ChargeItem;
import org.hl7.fhir.r4.model.Invoice;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class InvoiceIInvoiceTransformer
implements IFhirTransformer<Invoice, IInvoice> {
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService coreModelService;
    @Reference(target="(transformer.id=ChargeItem.IBilled)")
    private IFhirTransformer<ChargeItem, IBilled> chargeItemTransformer;
    private IInvoiceInvoiceAttributeMapper attributeMapper;

    @Activate
    private void activate() {
        this.attributeMapper = new IInvoiceInvoiceAttributeMapper(this.chargeItemTransformer);
    }

    @Override
    public Optional<Invoice> getFhirObject(IInvoice localObject, SummaryEnum summaryEnum, Set<Include> includes) {
        Invoice invoice = new Invoice();
        this.attributeMapper.elexisToFhir(localObject, invoice, summaryEnum, includes);
        return Optional.of(invoice);
    }

    @Override
    public Optional<IInvoice> getLocalObject(Invoice fhirObject) {
        Optional<String> localId;
        if (fhirObject != null && fhirObject.getId() != null && (localId = FhirUtil.getLocalId(fhirObject.getId())).isPresent()) {
            return this.coreModelService.load(localId.get(), IInvoice.class);
        }
        return Optional.empty();
    }

    @Override
    public Optional<IInvoice> updateLocalObject(Invoice fhirObject, IInvoice localObject) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Optional<IInvoice> createLocalObject(Invoice fhirObject) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean matchesTypes(Class<?> fhirClazz, Class<?> localClazz) {
        return Invoice.class.equals(fhirClazz) && IInvoice.class.equals(localClazz);
    }
}

