/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.accessor;

public class EnumMapping {
    private Class<? extends Enum> fhirEnum;
    private Enum<?> defaultFhirEnum;
    private Class<? extends Enum> localEnum;
    private Enum<?> defaultLocalEnum;

    public EnumMapping(Class<? extends Enum<?>> fhirEnum, Enum<?> defaultFhirEnum, Class<? extends Enum<?>> localEnum, Enum<?> defualtLocalEnum) {
        this.fhirEnum = fhirEnum;
        this.defaultFhirEnum = defaultFhirEnum;
        this.localEnum = localEnum;
        this.defaultLocalEnum = defualtLocalEnum;
    }

    public Enum<?> getLocalEnumValueByEnum(Enum<?> fhirEnumValue) {
        return Enum.valueOf(this.localEnum, fhirEnumValue.name());
    }

    public Enum<?> getLocalEnumValueByCode(String code) {
        try {
            return Enum.valueOf(this.localEnum, code.replaceAll("-", ""));
        }
        catch (IllegalArgumentException ia) {
            return this.defaultLocalEnum;
        }
    }

    public Enum<?> getFhirEnumValueByEnum(Enum<?> localEnumValue) {
        return Enum.valueOf(this.fhirEnum, localEnumValue.name());
    }

    public Enum<?> getFhirEnumValueByCode(String code) {
        try {
            return Enum.valueOf(this.fhirEnum, code.replaceAll("-", ""));
        }
        catch (IllegalArgumentException ia) {
            return this.defaultFhirEnum;
        }
    }
}

