/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.ui.views;

import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.IObservation;
import ch.elexis.core.findings.codes.CodingSystem;
import ch.elexis.core.findings.util.ModelUtil;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.viewers.LabelProvider;

public class ObservationLabelProvider
extends LabelProvider {
    public String getText(Object element) {
        if (element instanceof IObservation) {
            return this.getLabelText((IObservation)element);
        }
        return super.getText(element);
    }

    private String getLabelText(IObservation observation) {
        String title;
        String ret = observation.getText().orElse("").trim();
        Optional coding = ModelUtil.getCodeBySystem((List)observation.getCoding(), (CodingSystem)CodingSystem.ELEXIS_LOCAL_CODESYSTEM);
        String string = title = coding.isPresent() ? ((ICoding)coding.get()).getDisplay() : "";
        if (StringUtils.isNotBlank((CharSequence)title) && ret.startsWith(title) && (ret = ret.substring(title.length(), ret.length()).trim()).startsWith(": ")) {
            ret = ret.substring(": ".length(), ret.length());
        }
        return ret;
    }
}

