/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.templates.ui.dlg;

import ch.elexis.core.findings.templates.model.FindingsTemplate;
import ch.elexis.core.findings.templates.model.FindingsTemplates;
import ch.elexis.core.findings.templates.model.InputData;
import ch.elexis.core.findings.templates.model.ModelFactory;
import ch.elexis.core.findings.templates.model.Type;
import ch.elexis.core.findings.templates.ui.composite.FindingsDetailComposite;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class FindingsDialog
extends TitleAreaDialog {
    private final FindingsTemplates model;
    private FindingsDetailComposite findingsDetailComposite;

    public FindingsDialog(Shell parentShell, FindingsTemplates model) {
        super(parentShell);
        this.setShellStyle(16);
        this.model = model;
    }

    protected Control createDialogArea(Composite parent) {
        this.setMessage("Neue Befundvorlage anlegen");
        this.setTitle("Befund Vorlage");
        this.findingsDetailComposite = new FindingsDetailComposite(parent, this.model, true);
        this.findingsDetailComposite.createContents();
        FindingsTemplate findingsTemplate = ModelFactory.eINSTANCE.createFindingsTemplate();
        findingsTemplate.setTitle("");
        findingsTemplate.setType(Type.OBSERVATION_VITAL);
        findingsTemplate.setInputData((InputData)ModelFactory.eINSTANCE.createInputDataNumeric());
        this.findingsDetailComposite.setSelection(this.model, findingsTemplate);
        return this.findingsDetailComposite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
    }

    protected void okPressed() {
        FindingsTemplate findingsTemplate = this.findingsDetailComposite.getResult();
        if (findingsTemplate != null) {
            this.model.getFindingsTemplates().add((Object)findingsTemplate);
            super.okPressed();
        }
    }

    protected boolean isResizable() {
        return true;
    }
}

