/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.fhir.model.service;

import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.codes.IValueSetContribution;
import ch.elexis.core.findings.codes.IValueSetService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class ValueSetService
implements IValueSetService {
    private List<IValueSetContribution> contributions;
    private Map<String, IValueSetContribution> idContributionMap;
    private Map<String, IValueSetContribution> nameContributionMap;

    private Logger getLogger() {
        return LoggerFactory.getLogger(ValueSetService.class);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.STATIC, policyOption=ReferencePolicyOption.GREEDY)
    public synchronized void bindContribution(IValueSetContribution contribution) {
        if (contribution.getValueSetIds() != null && !contribution.getValueSetIds().isEmpty()) {
            this.addContribution(contribution);
        } else {
            this.getLogger().warn("Contribution " + String.valueOf(contribution) + " returns no value set ids. It will be ignored.");
        }
    }

    private void addContribution(IValueSetContribution contribution) {
        if (this.contributions == null) {
            this.contributions = new ArrayList<IValueSetContribution>();
        }
        if (this.idContributionMap == null) {
            this.idContributionMap = new HashMap<String, IValueSetContribution>();
        }
        if (this.nameContributionMap == null) {
            this.nameContributionMap = new HashMap<String, IValueSetContribution>();
        }
        this.contributions.add(contribution);
        List ids = contribution.getValueSetIds();
        for (String id : ids) {
            if (this.idContributionMap.put(id, contribution) == null) continue;
            this.getLogger().warn("Id " + id + " provided by multiple contributions " + String.valueOf(contribution));
        }
        List names = contribution.getValueSetNames();
        for (String name : names) {
            if (this.nameContributionMap.put(name, contribution) == null) continue;
            this.getLogger().warn("Name " + name + " provided by multiple contributions " + String.valueOf(contribution));
        }
    }

    public void unbindContribution(IValueSetContribution contribution) {
        if (this.contributions == null) {
            this.contributions = new ArrayList<IValueSetContribution>();
        }
        this.removeContribution(contribution);
    }

    private void removeContribution(IValueSetContribution contribution) {
        if (this.contributions == null) {
            this.contributions = new ArrayList<IValueSetContribution>();
        }
        if (this.idContributionMap == null) {
            this.idContributionMap = new HashMap<String, IValueSetContribution>();
        }
        if (this.nameContributionMap == null) {
            this.nameContributionMap = new HashMap<String, IValueSetContribution>();
        }
        this.contributions.remove(contribution);
        List ids = contribution.getValueSetIds();
        for (String id : ids) {
            this.idContributionMap.remove(id);
        }
        List names = contribution.getValueSetNames();
        for (String name : names) {
            this.nameContributionMap.remove(name);
        }
    }

    public List<ICoding> getValueSet(String id) {
        if (this.idContributionMap != null && this.idContributionMap.get(id) != null) {
            return this.idContributionMap.get(id).getValueSet(id);
        }
        return Collections.emptyList();
    }

    public List<ICoding> getValueSetByName(String name) {
        if (this.nameContributionMap != null && this.nameContributionMap.get(name) != null) {
            return this.nameContributionMap.get(name).getValueSetByName(name);
        }
        return Collections.emptyList();
    }
}

