/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.fhir.model.service;

import ch.elexis.core.model.IDocument;
import ch.elexis.core.services.IDocumentStore;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.LoggerFactory;

@Component
public class DocumentStoreHolder {
    private static ConcurrentMap<String, IDocumentStore> services = new ConcurrentHashMap<String, IDocumentStore>();

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    void addDocumentStore(IDocumentStore store) {
        services.put(store.getId(), store);
    }

    void removeDocumentStore(IDocumentStore store) {
        services.remove(store.getId());
    }

    public static Optional<IDocument> getDocument(String documentStoreId, String documentId) {
        if (StringUtils.isNotBlank((CharSequence)documentStoreId) && StringUtils.isNotBlank((CharSequence)documentId)) {
            IDocumentStore store = (IDocumentStore)services.get(documentStoreId);
            if (store != null) {
                return store.loadDocument(documentId);
            }
            LoggerFactory.getLogger(DocumentStoreHolder.class).warn("Could not get store for id [" + documentStoreId + "]");
        }
        return Optional.empty();
    }
}

