/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.fhir.model.impl;

import ca.uhn.fhir.model.primitive.IdDt;
import ch.elexis.core.fhir.model.impl.AbstractFhirModelAdapter;
import ch.elexis.core.fhir.model.impl.FhirModelServiceHolder;
import ch.elexis.core.findings.util.fhir.transformer.helper.FhirUtil;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IReminder;
import ch.elexis.core.model.IUserGroup;
import ch.elexis.core.model.issue.Priority;
import ch.elexis.core.model.issue.ProcessStatus;
import ch.elexis.core.model.issue.Type;
import ch.elexis.core.model.issue.Visibility;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.Annotation;
import org.hl7.fhir.r4.model.CareTeam;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.Period;
import org.hl7.fhir.r4.model.Person;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Task;

public class FhirReminder
extends AbstractFhirModelAdapter<Task>
implements IReminder {
    private IContact creator;
    private IContact contact;

    public FhirReminder(Task fhirResource) {
        super(fhirResource);
    }

    public IContact getCreator() {
        Optional<IContact> requestorContact;
        if (this.creator == null && ((Task)this.getFhirResource()).hasRequester() && Practitioner.class.getSimpleName().equals(((Task)this.getFhirResource()).getRequester().getReferenceElement().getResourceType()) && (requestorContact = FhirModelServiceHolder.get().load(((Task)this.getFhirResource()).getRequester().getReferenceElement().getIdPart(), IContact.class)).isPresent()) {
            this.creator = requestorContact.get();
        }
        return this.creator;
    }

    public void setCreator(IContact value) {
        if (value != null) {
            if (value.isPatient()) {
                Reference patientReference = new Reference((IIdType)new IdDt(Patient.class.getSimpleName(), value.getId()));
                ((Task)this.getFhirResource()).setRequester(patientReference);
                this.creator = value;
            } else if (value.isMandator()) {
                Reference practitionerReference = new Reference((IIdType)new IdDt(Practitioner.class.getSimpleName(), value.getId()));
                ((Task)this.getFhirResource()).setRequester(practitionerReference);
                this.creator = value;
            }
        } else {
            this.creator = null;
            ((Task)this.getFhirResource()).setRequester(null);
        }
    }

    public IContact getContact() {
        if (this.contact == null && ((Task)this.getFhirResource()).hasFor()) {
            Optional<IContact> forContact;
            if (Patient.class.getSimpleName().equals(((Task)this.getFhirResource()).getFor().getReferenceElement().getResourceType())) {
                Optional<IPatient> forContact2 = FhirModelServiceHolder.get().load(((Task)this.getFhirResource()).getFor().getReferenceElement().getIdPart(), IPatient.class);
                if (forContact2.isPresent()) {
                    this.contact = (IContact)forContact2.get();
                }
            } else if (Practitioner.class.getSimpleName().equals(((Task)this.getFhirResource()).getFor().getReferenceElement().getResourceType()) && (forContact = FhirModelServiceHolder.get().load(((Task)this.getFhirResource()).getFor().getReferenceElement().getIdPart(), IContact.class)).isPresent()) {
                this.contact = forContact.get();
            }
        }
        return this.contact;
    }

    public void setContact(IContact value) {
        if (value != null) {
            if (value.isPatient()) {
                Reference patientReference = new Reference((IIdType)new IdDt(Patient.class.getSimpleName(), value.getId()));
                ((Task)this.getFhirResource()).setFor(patientReference);
                this.contact = value;
            } else if (value.isMandator()) {
                Reference practitionerReference = new Reference((IIdType)new IdDt(Practitioner.class.getSimpleName(), value.getId()));
                ((Task)this.getFhirResource()).setFor(practitionerReference);
                this.contact = value;
            }
        } else {
            this.contact = null;
            ((Task)this.getFhirResource()).setFor(null);
        }
    }

    public LocalDate getDue() {
        if (((Task)this.getFhirResource()).hasExecutionPeriod() && ((Task)this.getFhirResource()).getExecutionPeriod().hasEnd()) {
            return LocalDate.ofInstant(((Task)this.getFhirResource()).getExecutionPeriod().getEnd().toInstant(), ZoneId.systemDefault());
        }
        return null;
    }

    public void setDue(LocalDate value) {
        if (value != null) {
            ((Task)this.getFhirResource()).setExecutionPeriod(new Period().setEnd(Date.from(value.atStartOfDay(ZoneId.systemDefault()).toInstant())));
        } else {
            ((Task)this.getFhirResource()).setExecutionPeriod(null);
        }
    }

    public ProcessStatus getStatus() {
        switch (((Task)this.getFhirResource()).getStatus()) {
            case DRAFT: 
            case REQUESTED: 
            case RECEIVED: 
            case ACCEPTED: 
            case READY: {
                return ProcessStatus.OPEN;
            }
            case REJECTED: 
            case CANCELLED: 
            case FAILED: 
            case COMPLETED: 
            case ENTEREDINERROR: {
                return ProcessStatus.CLOSED;
            }
            case INPROGRESS: {
                return ProcessStatus.IN_PROGRESS;
            }
            case ONHOLD: {
                return ProcessStatus.ON_HOLD;
            }
        }
        return ProcessStatus.OPEN;
    }

    public void setStatus(ProcessStatus value) {
        switch (value) {
            case CLOSED: {
                ((Task)this.getFhirResource()).setStatus(Task.TaskStatus.COMPLETED);
                return;
            }
            case IN_PROGRESS: {
                ((Task)this.getFhirResource()).setStatus(Task.TaskStatus.INPROGRESS);
                return;
            }
            case ON_HOLD: {
                ((Task)this.getFhirResource()).setStatus(Task.TaskStatus.ONHOLD);
                return;
            }
            case OPEN: 
            case DUE: 
            case OVERDUE: {
                ((Task)this.getFhirResource()).setStatus(Task.TaskStatus.ACCEPTED);
                return;
            }
        }
        ((Task)this.getFhirResource()).setStatus(Task.TaskStatus.DRAFT);
    }

    public Visibility getVisibility() {
        Optional visibilityCode;
        if (((Task)this.getFhirResource()).hasCode() && (visibilityCode = FhirUtil.getCodeFromCodingList((String)"http://www.elexis.info/task/visibility", (List)((Task)this.getFhirResource()).getCode().getCoding())).isPresent()) {
            return Visibility.valueOf((String)((String)visibilityCode.get()));
        }
        return Visibility.ALWAYS;
    }

    public void setVisibility(Visibility value) {
        ((Task)this.getFhirResource()).getCode().setCoding(new ArrayList<Coding>(((Task)this.getFhirResource()).getCode().getCoding().stream().filter(c -> !"http://www.elexis.info/task/visibility".equals(c.getSystem())).toList()));
        if (value != null) {
            ((Task)this.getFhirResource()).getCode().addCoding(new Coding("http://www.elexis.info/task/visibility", value.name(), value.getLocaleText()));
        }
    }

    public String getSubject() {
        return ((Task)this.getFhirResource()).getDescription();
    }

    public void setSubject(String value) {
        ((Task)this.getFhirResource()).setDescription(value);
    }

    public String getMessage() {
        return ((Task)this.getFhirResource()).getNote().stream().map(n -> n.getText()).collect(Collectors.joining("\n\n"));
    }

    public void setMessage(String value) {
        ((Task)this.getFhirResource()).setNote(List.of(new Annotation().setText(value)));
    }

    public Priority getPriority() {
        switch (((Task)this.getFhirResource()).getPriority()) {
            case URGENT: 
            case ASAP: 
            case STAT: {
                return Priority.HIGH;
            }
            case ROUTINE: {
                return Priority.MEDIUM;
            }
        }
        return Priority.MEDIUM;
    }

    public void setPriority(Priority value) {
        ((Task)this.getFhirResource()).setPriority(this.getTaskPriority(value));
    }

    private Task.TaskPriority getTaskPriority(Priority value) {
        switch (value) {
            case HIGH: {
                return Task.TaskPriority.URGENT;
            }
            case LOW: 
            case MEDIUM: {
                return Task.TaskPriority.ROUTINE;
            }
        }
        return Task.TaskPriority.ROUTINE;
    }

    public Type getType() {
        Optional visibilityCode;
        if (((Task)this.getFhirResource()).hasCode() && (visibilityCode = FhirUtil.getCodeFromCodingList((String)"http://www.elexis.info/task/type", (List)((Task)this.getFhirResource()).getCode().getCoding())).isPresent()) {
            return Type.valueOf((String)((String)visibilityCode.get()));
        }
        return Type.COMMON;
    }

    public void setType(Type value) {
        ((Task)this.getFhirResource()).getCode().setCoding(new ArrayList<Coding>(((Task)this.getFhirResource()).getCode().getCoding().stream().filter(c -> !"http://www.elexis.info/task/type".equals(c.getSystem())).toList()));
        if (value != null) {
            ((Task)this.getFhirResource()).getCode().addCoding(new Coding("http://www.elexis.info/task/type", value.name(), value.getLocaleText()));
        }
    }

    public boolean isResponsibleAll() {
        if (((Task)this.getFhirResource()).hasOwner() && CareTeam.class.getSimpleName().equals(((Task)this.getFhirResource()).getOwner().getReferenceElement().getResourceType())) {
            return "all".equalsIgnoreCase(((Task)this.getFhirResource()).getOwner().getReferenceElement().getIdPart());
        }
        return false;
    }

    public void setResponsibleAll(boolean value) {
        if (value) {
            Reference groupReference = new Reference((IIdType)new IdDt(CareTeam.class.getSimpleName(), "ALL"));
            ((Task)this.getFhirResource()).setOwner(groupReference);
        } else if (((Task)this.getFhirResource()).hasOwner() && ((Task)this.getFhirResource()).getOwner().getReferenceElement().getIdPart().equalsIgnoreCase("ALL")) {
            ((Task)this.getFhirResource()).setOwner(null);
        }
    }

    public IUserGroup getGroup() {
        Optional<IUserGroup> ownerGroup;
        if (((Task)this.getFhirResource()).hasOwner() && CareTeam.class.getSimpleName().equals(((Task)this.getFhirResource()).getOwner().getReferenceElement().getResourceType()) && !"all".equalsIgnoreCase(((Task)this.getFhirResource()).getOwner().getReferenceElement().getIdPart()) && (ownerGroup = FhirModelServiceHolder.get().load(((Task)this.getFhirResource()).getOwner().getReferenceElement().getIdPart(), IUserGroup.class)).isPresent()) {
            return ownerGroup.get();
        }
        return null;
    }

    public void setGroup(IUserGroup value) {
        if (value != null) {
            Reference groupReference = new Reference((IIdType)new IdDt(CareTeam.class.getSimpleName(), value.getId()));
            ((Task)this.getFhirResource()).setOwner(groupReference);
        } else {
            ((Task)this.getFhirResource()).setOwner(null);
        }
    }

    public List<IContact> getResponsible() {
        Optional<IContact> ownerContact;
        if (((Task)this.getFhirResource()).hasOwner() && Practitioner.class.getSimpleName().equals(((Task)this.getFhirResource()).getOwner().getReferenceElement().getResourceType()) && (ownerContact = FhirModelServiceHolder.get().load(((Task)this.getFhirResource()).getOwner().getReferenceElement().getIdPart(), IContact.class)).isPresent()) {
            return Collections.singletonList(ownerContact.get());
        }
        return Collections.emptyList();
    }

    public void addResponsible(IContact responsible) {
        if (responsible.isOrganization()) {
            Reference organizationReference = new Reference((IIdType)new IdDt(Organization.class.getSimpleName(), responsible.getId()));
            ((Task)this.getFhirResource()).setOwner(organizationReference);
        } else if (responsible.isMandator()) {
            Reference practitionerReference = new Reference((IIdType)new IdDt(Practitioner.class.getSimpleName(), responsible.getId()));
            ((Task)this.getFhirResource()).setOwner(practitionerReference);
        } else {
            Reference personReference = new Reference((IIdType)new IdDt(Person.class.getSimpleName(), responsible.getId()));
            ((Task)this.getFhirResource()).setOwner(personReference);
        }
    }

    public void removeResponsible(IContact responsible) {
        ((Task)this.getFhirResource()).setOwner(null);
    }

    public boolean isDeleted() {
        return false;
    }

    public void setDeleted(boolean value) {
        throw new UnsupportedOperationException();
    }

    public boolean addXid(String domain, String id, boolean updateIfExists) {
        return false;
    }

    public Object getExtInfo(Object key) {
        return null;
    }

    public void setExtInfo(Object key, Object value) {
    }

    public Map<Object, Object> getMap() {
        return null;
    }

    @Override
    public Class<Task> getFhirType() {
        return Task.class;
    }

    @Override
    public Class<?> getModelType() {
        return IReminder.class;
    }
}

