/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.service.StoreToStringServiceHolder;
import ch.elexis.core.jdt.Nullable;
import ch.elexis.core.model.ICodeElementBlock;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.data.Leistungsblock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerrechenbarFavorites {
    public static final String USER_CFG_FAVORITES = "verrechenbar/favoriten";
    private static List<Favorite> favorites;
    private static Logger log;

    static {
        log = LoggerFactory.getLogger(VerrechenbarFavorites.class);
    }

    public static List<Favorite> getFavorites() {
        if (favorites == null) {
            favorites = new ArrayList<Favorite>();
            String favs = ConfigServiceHolder.getUser((String)USER_CFG_FAVORITES, (String)"");
            String[] entries = favs.split(";");
            int i = 0;
            while (i < entries.length) {
                String entry = entries[i];
                if (entry.contains(",")) {
                    String[] value = entry.split(",");
                    Favorite f = new Favorite(value[1], value[0], i);
                    favorites.add(f);
                }
                ++i;
            }
            Collections.sort(favorites);
        }
        return favorites;
    }

    public static void storeFavorites() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < favorites.size()) {
            Favorite f = favorites.get(i);
            sb.append(f.macroString + "," + f.storeToString);
            if (i != favorites.size() - 1) {
                sb.append(";");
            }
            ++i;
        }
        ConfigServiceHolder.setUser((String)USER_CFG_FAVORITES, (String)sb.toString());
        ElexisEventDispatcher.reload(Favorite.class);
    }

    public static void setFavorite(Object object, boolean val) {
        Favorite fav = VerrechenbarFavorites.isFavorite(object);
        if (val) {
            if (fav != null) {
                return;
            }
            String storeToString = StoreToStringServiceHolder.getStoreToString(object);
            VerrechenbarFavorites.getFavorites().add(new Favorite(storeToString, "", 0));
        } else {
            if (fav == null) {
                return;
            }
            VerrechenbarFavorites.getFavorites().remove(fav);
        }
        VerrechenbarFavorites.storeFavorites();
    }

    public static Favorite isFavorite(Object object) {
        for (Favorite favorite : VerrechenbarFavorites.getFavorites()) {
            String comparator = StoreToStringServiceHolder.getStoreToString(object);
            if (!comparator.equalsIgnoreCase(favorite.storeToString)) continue;
            return favorite;
        }
        return null;
    }

    @Nullable
    public static Favorite findFavoritByMacroForCurrentUser(@Nullable String macro) {
        if (macro == null) {
            return null;
        }
        for (Favorite favorite : VerrechenbarFavorites.getFavorites()) {
            if (!macro.equals(favorite.macroString)) continue;
            return favorite;
        }
        return null;
    }

    public static void reset() {
        favorites = null;
        ElexisEventDispatcher.reload(Favorite.class);
    }

    public static class Favorite
    implements Comparable<Favorite> {
        String storeToString;
        String macroString;
        int order;

        public Favorite(String storeToString, String macroString, int order) {
            this.storeToString = storeToString;
            this.macroString = macroString;
            this.order = order;
        }

        @Override
        public int compareTo(Favorite o) {
            return Integer.compare(this.order, o.order);
        }

        public String getStoreToString() {
            return this.storeToString;
        }

        public void setStoreToString(String storeToString) {
            this.storeToString = storeToString;
        }

        public String getMacroString() {
            if (this.storeToString.startsWith(Leistungsblock.class.getName())) {
                ICodeElementBlock block = this.getObject().orElse(null);
                return block != null ? block.getMacro() : this.macroString;
            }
            return this.macroString;
        }

        public void setMacroString(String macroString) {
            if (this.storeToString.startsWith(Leistungsblock.class.getName())) {
                ICodeElementBlock block = this.getObject().orElse(null);
                if (block != null) {
                    block.setMacro(macroString);
                } else {
                    log.warn("Could not set macroString " + macroString + " to Leistungsblock  as po is null.");
                }
            }
            this.macroString = macroString;
        }

        public int getOrder() {
            return this.order;
        }

        public void setOrder(int order) {
            this.order = order;
        }

        public Optional<Identifiable> getObject() {
            return StoreToStringServiceHolder.get().loadFromString(this.storeToString);
        }
    }
}

