/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.data.interfaces.IFall;
import ch.elexis.core.data.util.MultiplikatorList;
import ch.elexis.data.VerrechenbarAdapter;
import ch.elexis.data.Xid;
import ch.rgw.tools.Money;
import ch.rgw.tools.TimeTool;

public class Eigenleistung
extends VerrechenbarAdapter {
    public static final String CODESYSTEM_NAME = "Eigenleistung";
    public static final String TIME = "Zeit";
    public static final String VK_PREIS = "VK_Preis";
    public static final String EK_PREIS = "EK_Preis";
    public static final String BEZEICHNUNG = "Bezeichnung";
    public static final String CODE = "Code";
    public static final String EIGENLEISTUNGEN = "EIGENLEISTUNGEN";
    public static final String XIDDOMAIN = "www.xid.ch/id/customservices";

    static {
        Eigenleistung.addMapping(EIGENLEISTUNGEN, CODE, BEZEICHNUNG, EK_PREIS, VK_PREIS, TIME);
        Xid.localRegisterXIDDomainIfNotExists(XIDDOMAIN, CODESYSTEM_NAME, 5);
    }

    @Override
    public String getXidDomain() {
        return XIDDOMAIN;
    }

    @Override
    protected String getTableName() {
        return EIGENLEISTUNGEN;
    }

    @Override
    public String getCode() {
        String ret = this.get(CODE);
        if (ret == null || ret.isEmpty()) {
            ret = this.getId();
        }
        return ret;
    }

    @Override
    public String getText() {
        return this.get(BEZEICHNUNG);
    }

    public String[] getDisplayedFields() {
        return new String[]{CODE, BEZEICHNUNG};
    }

    @Override
    public String getCodeSystemName() {
        return CODESYSTEM_NAME;
    }

    @Override
    public Money getKosten(TimeTool dat) {
        return new Money(Eigenleistung.checkZero(this.get(EK_PREIS)));
    }

    public Money getPreis(TimeTool dat, IFall fall) {
        return new Money(Eigenleistung.checkZero(this.get(VK_PREIS)));
    }

    public Eigenleistung(String code, String name, String ek, String vk) {
        this.create(null);
        this.set(new String[]{CODE, BEZEICHNUNG, EK_PREIS, VK_PREIS}, code, name, ek, vk);
    }

    protected Eigenleistung() {
    }

    protected Eigenleistung(String id) {
        super(id);
    }

    public static Eigenleistung load(String id) {
        return new Eigenleistung(id);
    }

    @Override
    public boolean isDragOK() {
        return true;
    }

    @Override
    public int getTP(TimeTool date, IFall fall) {
        return this.getPreis(date, fall).getCents();
    }

    @Override
    public double getFactor(TimeTool date, IFall fall) {
        if (MultiplikatorList.isEigenleistungUseMulti(fall.getAbrechnungsSystem())) {
            return this.getVKMultiplikator(date, fall);
        }
        return 1.0;
    }
}

