/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.data.Fall;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;

public class AUF
extends PersistentObject {
    public static final String FLD_PERCENT = "Prozent";
    public static final String FLD_REASON = "Grund";
    public static final String FLD_CASE_ID = "FallID";
    public static final String FLD_PATIENT_ID = "PatientID";
    public static final String TABLENAME = "AUF";
    public static final String FLD_ZUSATZ = "Zusatz";
    public static final String FLD_DATE_FROM = "von";
    public static final String FLD_DATE_UNTIL = "bis";

    static {
        AUF.addMapping(TABLENAME, FLD_PATIENT_ID, FLD_CASE_ID, "von=S:D:DatumVon", "bis=S:D:DatumBis", FLD_REASON, FLD_PERCENT, "Zusatz=AUFZusatz", "Erstellt=S:D:DatumAUZ");
    }

    public AUF(Fall f, String von, String bis, String proz, String grund) {
        Patient p;
        if (f != null && (p = f.getPatient()) != null) {
            this.create(null);
            this.set(new String[]{FLD_PATIENT_ID, FLD_CASE_ID, FLD_DATE_FROM, FLD_DATE_UNTIL, FLD_PERCENT, FLD_REASON, "Erstellt"}, p.getId(), f.getId(), von, bis, proz, grund, new TimeTool().toString(4));
        }
    }

    @Override
    public String getLabel() {
        String[] f = new String[]{FLD_DATE_FROM, FLD_DATE_UNTIL, FLD_PERCENT, FLD_REASON, "Erstellt"};
        String[] v = new String[f.length];
        this.get(f, v);
        StringBuilder sb = new StringBuilder();
        if (!StringTool.isNothing((Object)v[4])) {
            sb.append("[").append(v[4]).append("]: ");
        }
        sb.append(v[0]).append("-").append(v[1]).append(": ").append(v[2]).append("% (").append(v[3]).append(")");
        return sb.toString();
    }

    public Patient getPatient() {
        return this.getFall().getPatient();
    }

    public Fall getFall() {
        return Fall.load(this.get(FLD_CASE_ID));
    }

    public TimeTool getBeginn() {
        return new TimeTool(AUF.checkNull(this.get(FLD_DATE_FROM)));
    }

    public TimeTool getEnd() {
        return new TimeTool(AUF.checkNull(this.get(FLD_DATE_UNTIL)));
    }

    public void setBeginn(String date) {
        this.set(FLD_DATE_FROM, date);
    }

    public void setEnd(String date) {
        this.set(FLD_DATE_UNTIL, date);
    }

    public String getGrund() {
        return AUF.checkNull(this.get(FLD_REASON));
    }

    public String getZusatz() {
        return AUF.checkNull(this.get(FLD_ZUSATZ));
    }

    public String getProzent() {
        return AUF.checkNull(this.get(FLD_PERCENT));
    }

    @Override
    protected String getTableName() {
        return TABLENAME;
    }

    public static AUF load(String id) {
        return new AUF(id);
    }

    protected AUF() {
    }

    protected AUF(String id) {
        super(id);
    }
}

