/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.data.cache;

import ch.elexis.core.data.cache.IPersistentObjectCache;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheStats;
import java.util.concurrent.TimeUnit;

public class GuavaCache<K>
implements IPersistentObjectCache<K> {
    private Cache<K, Object> shortTermCache;

    public GuavaCache(long duration, TimeUnit unit) {
        this.shortTermCache = CacheBuilder.newBuilder().softValues().recordStats().expireAfterWrite(duration, unit).build();
    }

    @Override
    public void put(K key, Object object, int timeToCacheInSeconds) {
        if (key == null || object == null) {
            return;
        }
        this.shortTermCache.put(key, object);
    }

    @Override
    public Object get(K key, int cacheTime) {
        return this.shortTermCache.getIfPresent(key);
    }

    @Override
    public Object get(K key) {
        return this.get(key, 0);
    }

    @Override
    public void remove(K key) {
        this.shortTermCache.invalidate(key);
    }

    @Override
    public void clear() {
        this.shortTermCache.invalidateAll();
    }

    @Override
    public void stat() {
        CacheStats shortStats = this.shortTermCache.stats();
        System.out.println("--------- GUAVA CACHE Statistics ---------");
        System.out.println("Hits (count/rate): " + shortStats.hitCount() + " / " + String.format("%.2f%%", shortStats.hitRate() * 100.0));
        System.out.println("Misses (count/rate): " + shortStats.missCount() + " / " + String.format("%.2f%%", shortStats.missRate() * 100.0));
        System.out.println("------------------------------------------");
    }

    @Override
    public void purge() {
        this.clear();
    }

    @Override
    public void reset() {
        this.clear();
    }
}

