/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.model.issue.ProcessStatus;
import ch.elexis.core.model.issue.Visibility;
import ch.elexis.data.AbstractPersistentObjectTest;
import ch.elexis.data.Anwender;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.elexis.data.Reminder;
import ch.elexis.data.User;
import ch.rgw.tools.TimeTool;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class Test_Reminder
extends AbstractPersistentObjectTest {
    private Anwender anwender;
    private Patient patient;
    private Reminder reminderA;
    private Reminder reminderB;
    private Reminder reminderC;

    public Test_Reminder() {
        User user = User.load((String)"Administrator");
        if (user.getAssignedContact() == null) {
            this.anwender = new Anwender("Name", "Vorname", null, "w");
            user.setAssignedContact((Kontakt)this.anwender);
        } else {
            this.anwender = user.getAssignedContact();
        }
        Mandant m = new Mandant("Mandant", "Erwin", "26.07.1979", "m");
        this.patient = new Patient("Mia", "Krank", "22041982", "w");
        CoreHub.setMandant((Mandant)m);
    }

    @After
    public void cleanup() {
        if (this.reminderA != null) {
            this.reminderA.delete();
            this.reminderA = null;
        }
        if (this.reminderB != null) {
            this.reminderB.delete();
            this.reminderB = null;
        }
        if (this.reminderC != null) {
            this.reminderC.delete();
            this.reminderC = null;
        }
    }

    @Test
    public void testSetResponsibleUser() throws InterruptedException {
        this.reminderA = new Reminder(null, new TimeTool().toString(4), Visibility.ALWAYS, "", "TestMessage");
        long lastUpdate = this.reminderA.getLastUpdate();
        Assert.assertNotSame((Object)0L, (Object)this.reminderA.getLastUpdate());
        Thread.sleep(2L);
        this.reminderA.setResponsible(Collections.singletonList(this.anwender));
        Assert.assertTrue((this.reminderA.getLastUpdate() > lastUpdate ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)this.reminderA.getResponsibles().size());
        Assert.assertEquals((Object)"", (Object)this.reminderA.get("Responsible"));
        lastUpdate = this.reminderA.getLastUpdate();
        Thread.sleep(2L);
        this.reminderA.setResponsible(new ArrayList());
        Assert.assertTrue((this.reminderA.getLastUpdate() > lastUpdate ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)this.reminderA.getResponsibles().size());
        Assert.assertEquals((Object)"", (Object)this.reminderA.get("Responsible"));
        this.reminderA.setResponsible(null);
        Assert.assertTrue((this.reminderA.getLastUpdate() > lastUpdate ? 1 : 0) != 0);
        Assert.assertNull((Object)this.reminderA.getResponsibles());
        Assert.assertEquals((Object)"ALL", (Object)this.reminderA.get("Responsible"));
    }

    @Test
    public void testFindOpenRemindersResponsibleFor() {
        this.reminderA = new Reminder(null, new TimeTool().toString(4), Visibility.ALWAYS, "", "TestMessage");
        this.reminderA.setResponsible(Collections.singletonList(CoreHub.getLoggedInContact()));
        this.reminderA.set("Status", Integer.toString(ProcessStatus.CLOSED.numericValue()));
        this.reminderB = new Reminder(null, new TimeTool().toString(4), Visibility.ALWAYS, "", "TestMessage");
        this.reminderB.setResponsible(Collections.singletonList(CoreHub.getLoggedInContact()));
        List findOpenRemindersResponsibleFor = Reminder.findOpenRemindersResponsibleFor((Anwender)CoreHub.getLoggedInContact(), (boolean)false, null, (boolean)false);
        Assert.assertEquals((long)1L, (long)findOpenRemindersResponsibleFor.size());
        this.reminderC = new Reminder((Kontakt)this.patient, new TimeTool().toString(4), Visibility.ALWAYS, "", "TestMessage");
        this.reminderC.setResponsible(null);
        Assert.assertEquals((long)2L, (long)Reminder.findOpenRemindersResponsibleFor((Anwender)CoreHub.getLoggedInContact(), (boolean)false, null, (boolean)false).size());
        Assert.assertEquals((long)1L, (long)Reminder.findOpenRemindersResponsibleFor(null, (boolean)false, (Patient)this.patient, (boolean)false).size());
        Reminder popupReminder = new Reminder((Kontakt)this.patient, new TimeTool().toString(4), Visibility.POPUP_ON_PATIENT_SELECTION, "", "TestMessage");
        popupReminder.setResponsible(Collections.singletonList(CoreHub.getLoggedInContact()));
        Assert.assertEquals((long)3L, (long)Reminder.findOpenRemindersResponsibleFor((Anwender)CoreHub.getLoggedInContact(), (boolean)false, null, (boolean)false).size());
        Assert.assertEquals((long)1L, (long)Reminder.findOpenRemindersResponsibleFor((Anwender)CoreHub.getLoggedInContact(), (boolean)false, null, (boolean)true).size());
        Assert.assertEquals((long)1L, (long)Reminder.findOpenRemindersResponsibleFor((Anwender)CoreHub.getLoggedInContact(), (boolean)false, (Patient)this.patient, (boolean)true).size());
        TimeTool timeTool = new TimeTool(LocalDate.now().minusDays(1L));
        Reminder dueReminder = new Reminder(null, timeTool.toString(4), Visibility.ALWAYS, "", "TestMessage");
        dueReminder.setResponsible(Collections.singletonList(this.anwender));
        List dueReminders = Reminder.findOpenRemindersResponsibleFor((Anwender)this.anwender, (boolean)true, null, (boolean)false);
        Assert.assertEquals((long)2L, (long)dueReminders.size());
        dueReminder.delete();
        popupReminder.delete();
    }

    @Test
    public void testFindAllUserIsResponsibleFor() {
        this.reminderA = new Reminder(null, new TimeTool().toString(4), Visibility.ALWAYS, "", "TestMessage");
        this.reminderA.setResponsible(Collections.singletonList(CoreHub.getLoggedInContact()));
        this.reminderA.set("Status", Integer.toString(ProcessStatus.CLOSED.numericValue()));
        this.reminderB = new Reminder(null, new TimeTool().toString(4), Visibility.ALWAYS, "", "TestMessage");
        this.reminderB.setResponsible(Collections.singletonList(CoreHub.getLoggedInContact()));
        this.reminderC = new Reminder(null, null, Visibility.ALWAYS, "", "TestMessage");
        this.reminderC.setResponsible(null);
        Assert.assertEquals((long)3L, (long)Reminder.findAllUserIsResponsibleFor((Anwender)CoreHub.getLoggedInContact(), (boolean)false).size());
        Assert.assertEquals((long)2L, (long)Reminder.findAllUserIsResponsibleFor((Anwender)CoreHub.getLoggedInContact(), (boolean)true).size());
    }

    @Test
    public void testFindRemindersDueFor() {
        this.reminderA = new Reminder(null, new TimeTool().toString(4), Visibility.ALWAYS, "", "TestMessage");
        this.reminderA.setResponsible(Collections.singletonList(CoreHub.getLoggedInContact()));
        this.reminderA.set("Due", new TimeTool().toString(4));
        this.reminderB = new Reminder(null, new TimeTool().toString(4), Visibility.ALWAYS, "", "TestMessage");
        this.reminderB.setResponsible(Collections.singletonList(CoreHub.getLoggedInContact()));
        TimeTool timeTool = new TimeTool();
        timeTool.addDays(-2);
        this.reminderB.set("Due", timeTool.toString(4));
        this.reminderC = new Reminder(null, null, Visibility.ALWAYS, "", "TestMessage");
        this.reminderC.setResponsible(null);
        List findRemindersDueFor = Reminder.findRemindersDueFor(null, (Anwender)CoreHub.getLoggedInContact(), (boolean)false);
        Assert.assertEquals((long)2L, (long)findRemindersDueFor.size());
    }

    @Test
    public void testFindDifferentialChangedReminders() throws InterruptedException, SQLException {
        this.reminderA = new Reminder(null, new TimeTool().toString(4), Visibility.ALWAYS, "", "TestMessageA");
        long highestLastUpdate = PersistentObject.getHighestLastUpdate((String)"REMINDERS");
        Thread.sleep(5L);
        String sql = "UPDATE REMINDERS SET LASTUPDATE='" + System.currentTimeMillis() + "', MESSAGE='TestMessageAUpdated' WHERE ID='" + this.reminderA.getId() + "'";
        PreparedStatement ps = Reminder.getDefaultConnection().getPreparedStatement(sql);
        int executeUpdate = ps.executeUpdate();
        Assert.assertEquals((long)1L, (long)executeUpdate);
        Reminder.getDefaultConnection().releasePreparedStatement(ps);
        Query qre = new Query(Reminder.class);
        qre.add("lastupdate", ">", Long.toString(highestLastUpdate));
        List changed = qre.execute();
        Assert.assertEquals((long)1L, (long)changed.size());
        Assert.assertEquals((Object)"TestMessageA", (Object)((Reminder)changed.get(0)).getMessage());
        qre = new Query(Reminder.class, "REMINDERS", true, null);
        qre.add("lastupdate", ">", Long.toString(highestLastUpdate));
        changed = qre.execute();
        Assert.assertEquals((long)1L, (long)changed.size());
        Assert.assertEquals((Object)"TestMessageAUpdated", (Object)((Reminder)changed.get(0)).getMessage());
    }
}

