# UserApi

All URIs are relative to *http://localhost*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**deleteUserContactConfigurationEntryByKey**](UserApi.md#deleteUserContactConfigurationEntryByKey) | **DELETE** /api/v1/user/config/contact | Delete User Contact Configuration Entry By Key |
| [**deleteUserContactConfigurationEntryByKeyWithHttpInfo**](UserApi.md#deleteUserContactConfigurationEntryByKeyWithHttpInfo) | **DELETE** /api/v1/user/config/contact | Delete User Contact Configuration Entry By Key |
| [**findGlobalConfigurationDirectSubnodeKeysForGivenKey**](UserApi.md#findGlobalConfigurationDirectSubnodeKeysForGivenKey) | **GET** /api/v1/user/config/global-subnodekeys | Find the direct subnode keys for a given entry branch. Programmatically limited to specific branches. |
| [**findGlobalConfigurationDirectSubnodeKeysForGivenKeyWithHttpInfo**](UserApi.md#findGlobalConfigurationDirectSubnodeKeysForGivenKeyWithHttpInfo) | **GET** /api/v1/user/config/global-subnodekeys | Find the direct subnode keys for a given entry branch. Programmatically limited to specific branches. |
| [**getExecutiveDoctorsWorkingFor**](UserApi.md#getExecutiveDoctorsWorkingFor) | **GET** /api/v1/user/executive-doctors-working-for | Get executive doctors user is working for |
| [**getExecutiveDoctorsWorkingForWithHttpInfo**](UserApi.md#getExecutiveDoctorsWorkingForWithHttpInfo) | **GET** /api/v1/user/executive-doctors-working-for | Get executive doctors user is working for |
| [**getGlobalConfigurationValueByKey**](UserApi.md#getGlobalConfigurationValueByKey) | **GET** /api/v1/user/config/global | Get Global Configuration Value By Key |
| [**getGlobalConfigurationValueByKeyWithHttpInfo**](UserApi.md#getGlobalConfigurationValueByKeyWithHttpInfo) | **GET** /api/v1/user/config/global | Get Global Configuration Value By Key |
| [**getUserContactConfigurationValueByKey**](UserApi.md#getUserContactConfigurationValueByKey) | **GET** /api/v1/user/config/contact | Get User Contact Configuration Value By Key |
| [**getUserContactConfigurationValueByKeyWithHttpInfo**](UserApi.md#getUserContactConfigurationValueByKeyWithHttpInfo) | **GET** /api/v1/user/config/contact | Get User Contact Configuration Value By Key |
| [**getUserInfo**](UserApi.md#getUserInfo) | **GET** /api/v1/user/info | Get user information |
| [**getUserInfoWithHttpInfo**](UserApi.md#getUserInfoWithHttpInfo) | **GET** /api/v1/user/info | Get user information |
| [**setGlobalConfigurationValueByKey**](UserApi.md#setGlobalConfigurationValueByKey) | **PUT** /api/v1/user/config/global | Set Global Configuration Value By Key |
| [**setGlobalConfigurationValueByKeyWithHttpInfo**](UserApi.md#setGlobalConfigurationValueByKeyWithHttpInfo) | **PUT** /api/v1/user/config/global | Set Global Configuration Value By Key |
| [**setUserContactConfigurationValueByKey**](UserApi.md#setUserContactConfigurationValueByKey) | **PUT** /api/v1/user/config/contact | Set User Contact Configuration Value By Key |
| [**setUserContactConfigurationValueByKeyWithHttpInfo**](UserApi.md#setUserContactConfigurationValueByKeyWithHttpInfo) | **PUT** /api/v1/user/config/contact | Set User Contact Configuration Value By Key |



## deleteUserContactConfigurationEntryByKey

> void deleteUserContactConfigurationEntryByKey(key)

Delete User Contact Configuration Entry By Key

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,user&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.UserApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        UserApi apiInstance = new UserApi(defaultClient);
        String key = "key_example"; // String | 
        try {
            apiInstance.deleteUserContactConfigurationEntryByKey(key);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserApi#deleteUserContactConfigurationEntryByKey");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **key** | **String**|  | |

### Return type


null (empty response body)

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |

## deleteUserContactConfigurationEntryByKeyWithHttpInfo

> ApiResponse<Void> deleteUserContactConfigurationEntryByKey deleteUserContactConfigurationEntryByKeyWithHttpInfo(key)

Delete User Contact Configuration Entry By Key

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,user&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.ApiResponse;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.UserApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        UserApi apiInstance = new UserApi(defaultClient);
        String key = "key_example"; // String | 
        try {
            ApiResponse<Void> response = apiInstance.deleteUserContactConfigurationEntryByKeyWithHttpInfo(key);
            System.out.println("Status code: " + response.getStatusCode());
            System.out.println("Response headers: " + response.getHeaders());
        } catch (ApiException e) {
            System.err.println("Exception when calling UserApi#deleteUserContactConfigurationEntryByKey");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Response headers: " + e.getResponseHeaders());
            System.err.println("Reason: " + e.getResponseBody());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **key** | **String**|  | |

### Return type


ApiResponse<Void>

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## findGlobalConfigurationDirectSubnodeKeysForGivenKey

> List<String> findGlobalConfigurationDirectSubnodeKeysForGivenKey(key)

Find the direct subnode keys for a given entry branch. Programmatically limited to specific branches.

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,user&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.UserApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        UserApi apiInstance = new UserApi(defaultClient);
        String key = "key_example"; // String | 
        try {
            List<String> result = apiInstance.findGlobalConfigurationDirectSubnodeKeysForGivenKey(key);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserApi#findGlobalConfigurationDirectSubnodeKeysForGivenKey");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **key** | **String**|  | |

### Return type

**List&lt;String&gt;**


### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |

## findGlobalConfigurationDirectSubnodeKeysForGivenKeyWithHttpInfo

> ApiResponse<List<String>> findGlobalConfigurationDirectSubnodeKeysForGivenKey findGlobalConfigurationDirectSubnodeKeysForGivenKeyWithHttpInfo(key)

Find the direct subnode keys for a given entry branch. Programmatically limited to specific branches.

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,user&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.ApiResponse;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.UserApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        UserApi apiInstance = new UserApi(defaultClient);
        String key = "key_example"; // String | 
        try {
            ApiResponse<List<String>> response = apiInstance.findGlobalConfigurationDirectSubnodeKeysForGivenKeyWithHttpInfo(key);
            System.out.println("Status code: " + response.getStatusCode());
            System.out.println("Response headers: " + response.getHeaders());
            System.out.println("Response body: " + response.getData());
        } catch (ApiException e) {
            System.err.println("Exception when calling UserApi#findGlobalConfigurationDirectSubnodeKeysForGivenKey");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Response headers: " + e.getResponseHeaders());
            System.err.println("Reason: " + e.getResponseBody());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **key** | **String**|  | |

### Return type

ApiResponse<**List&lt;String&gt;**>


### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## getExecutiveDoctorsWorkingFor

> Set<String> getExecutiveDoctorsWorkingFor()

Get executive doctors user is working for

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,user&lt;br&gt;Retrieves the contact ids of the executive doctors the current user is working for

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.UserApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        UserApi apiInstance = new UserApi(defaultClient);
        try {
            Set<String> result = apiInstance.getExecutiveDoctorsWorkingFor();
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserApi#getExecutiveDoctorsWorkingFor");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

**Set&lt;String&gt;**


### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |

## getExecutiveDoctorsWorkingForWithHttpInfo

> ApiResponse<Set<String>> getExecutiveDoctorsWorkingFor getExecutiveDoctorsWorkingForWithHttpInfo()

Get executive doctors user is working for

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,user&lt;br&gt;Retrieves the contact ids of the executive doctors the current user is working for

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.ApiResponse;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.UserApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        UserApi apiInstance = new UserApi(defaultClient);
        try {
            ApiResponse<Set<String>> response = apiInstance.getExecutiveDoctorsWorkingForWithHttpInfo();
            System.out.println("Status code: " + response.getStatusCode());
            System.out.println("Response headers: " + response.getHeaders());
            System.out.println("Response body: " + response.getData());
        } catch (ApiException e) {
            System.err.println("Exception when calling UserApi#getExecutiveDoctorsWorkingFor");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Response headers: " + e.getResponseHeaders());
            System.err.println("Reason: " + e.getResponseBody());
            e.printStackTrace();
        }
    }
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

ApiResponse<**Set&lt;String&gt;**>


### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## getGlobalConfigurationValueByKey

> String getGlobalConfigurationValueByKey(key)

Get Global Configuration Value By Key

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,user&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.UserApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        UserApi apiInstance = new UserApi(defaultClient);
        String key = "key_example"; // String | 
        try {
            String result = apiInstance.getGlobalConfigurationValueByKey(key);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserApi#getGlobalConfigurationValueByKey");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **key** | **String**|  | |

### Return type

**String**


### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: text/plain

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |

## getGlobalConfigurationValueByKeyWithHttpInfo

> ApiResponse<String> getGlobalConfigurationValueByKey getGlobalConfigurationValueByKeyWithHttpInfo(key)

Get Global Configuration Value By Key

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,user&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.ApiResponse;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.UserApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        UserApi apiInstance = new UserApi(defaultClient);
        String key = "key_example"; // String | 
        try {
            ApiResponse<String> response = apiInstance.getGlobalConfigurationValueByKeyWithHttpInfo(key);
            System.out.println("Status code: " + response.getStatusCode());
            System.out.println("Response headers: " + response.getHeaders());
            System.out.println("Response body: " + response.getData());
        } catch (ApiException e) {
            System.err.println("Exception when calling UserApi#getGlobalConfigurationValueByKey");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Response headers: " + e.getResponseHeaders());
            System.err.println("Reason: " + e.getResponseBody());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **key** | **String**|  | |

### Return type

ApiResponse<**String**>


### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: text/plain

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## getUserContactConfigurationValueByKey

> String getUserContactConfigurationValueByKey(key, contactId)

Get User Contact Configuration Value By Key

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,user&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.UserApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        UserApi apiInstance = new UserApi(defaultClient);
        String key = "key_example"; // String | 
        String contactId = "contactId_example"; // String | Target contact to fetch value for. Limited to self and contact user is aobo
        try {
            String result = apiInstance.getUserContactConfigurationValueByKey(key, contactId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserApi#getUserContactConfigurationValueByKey");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **key** | **String**|  | |
| **contactId** | **String**| Target contact to fetch value for. Limited to self and contact user is aobo | [optional] |

### Return type

**String**


### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: text/plain

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |

## getUserContactConfigurationValueByKeyWithHttpInfo

> ApiResponse<String> getUserContactConfigurationValueByKey getUserContactConfigurationValueByKeyWithHttpInfo(key, contactId)

Get User Contact Configuration Value By Key

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,user&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.ApiResponse;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.UserApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        UserApi apiInstance = new UserApi(defaultClient);
        String key = "key_example"; // String | 
        String contactId = "contactId_example"; // String | Target contact to fetch value for. Limited to self and contact user is aobo
        try {
            ApiResponse<String> response = apiInstance.getUserContactConfigurationValueByKeyWithHttpInfo(key, contactId);
            System.out.println("Status code: " + response.getStatusCode());
            System.out.println("Response headers: " + response.getHeaders());
            System.out.println("Response body: " + response.getData());
        } catch (ApiException e) {
            System.err.println("Exception when calling UserApi#getUserContactConfigurationValueByKey");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Response headers: " + e.getResponseHeaders());
            System.err.println("Reason: " + e.getResponseBody());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **key** | **String**|  | |
| **contactId** | **String**| Target contact to fetch value for. Limited to self and contact user is aobo | [optional] |

### Return type

ApiResponse<**String**>


### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: text/plain

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## getUserInfo

> User getUserInfo(resolveViaKeycloak)

Get user information

User information as contained in the token

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.UserApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");

        UserApi apiInstance = new UserApi(defaultClient);
        Boolean resolveViaKeycloak = false; // Boolean | 
        try {
            User result = apiInstance.getUserInfo(resolveViaKeycloak);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserApi#getUserInfo");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **resolveViaKeycloak** | **Boolean**|  | [optional] [default to false] |

### Return type

[**User**](User.md)


### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |

## getUserInfoWithHttpInfo

> ApiResponse<User> getUserInfo getUserInfoWithHttpInfo(resolveViaKeycloak)

Get user information

User information as contained in the token

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.ApiResponse;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.UserApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");

        UserApi apiInstance = new UserApi(defaultClient);
        Boolean resolveViaKeycloak = false; // Boolean | 
        try {
            ApiResponse<User> response = apiInstance.getUserInfoWithHttpInfo(resolveViaKeycloak);
            System.out.println("Status code: " + response.getStatusCode());
            System.out.println("Response headers: " + response.getHeaders());
            System.out.println("Response body: " + response.getData());
        } catch (ApiException e) {
            System.err.println("Exception when calling UserApi#getUserInfo");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Response headers: " + e.getResponseHeaders());
            System.err.println("Reason: " + e.getResponseBody());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **resolveViaKeycloak** | **Boolean**|  | [optional] [default to false] |

### Return type

ApiResponse<[**User**](User.md)>


### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |


## setGlobalConfigurationValueByKey

> String setGlobalConfigurationValueByKey(key, body)

Set Global Configuration Value By Key

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,user&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.UserApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        UserApi apiInstance = new UserApi(defaultClient);
        String key = "key_example"; // String | 
        String body = "body_example"; // String | 
        try {
            String result = apiInstance.setGlobalConfigurationValueByKey(key, body);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserApi#setGlobalConfigurationValueByKey");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **key** | **String**|  | |
| **body** | **String**|  | |

### Return type

**String**


### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: text/plain
- **Accept**: text/plain

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |

## setGlobalConfigurationValueByKeyWithHttpInfo

> ApiResponse<String> setGlobalConfigurationValueByKey setGlobalConfigurationValueByKeyWithHttpInfo(key, body)

Set Global Configuration Value By Key

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,user&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.ApiResponse;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.UserApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        UserApi apiInstance = new UserApi(defaultClient);
        String key = "key_example"; // String | 
        String body = "body_example"; // String | 
        try {
            ApiResponse<String> response = apiInstance.setGlobalConfigurationValueByKeyWithHttpInfo(key, body);
            System.out.println("Status code: " + response.getStatusCode());
            System.out.println("Response headers: " + response.getHeaders());
            System.out.println("Response body: " + response.getData());
        } catch (ApiException e) {
            System.err.println("Exception when calling UserApi#setGlobalConfigurationValueByKey");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Response headers: " + e.getResponseHeaders());
            System.err.println("Reason: " + e.getResponseBody());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **key** | **String**|  | |
| **body** | **String**|  | |

### Return type

ApiResponse<**String**>


### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: text/plain
- **Accept**: text/plain

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## setUserContactConfigurationValueByKey

> void setUserContactConfigurationValueByKey(key, body)

Set User Contact Configuration Value By Key

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,user&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.UserApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        UserApi apiInstance = new UserApi(defaultClient);
        String key = "key_example"; // String | 
        String body = "body_example"; // String | 
        try {
            apiInstance.setUserContactConfigurationValueByKey(key, body);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserApi#setUserContactConfigurationValueByKey");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **key** | **String**|  | |
| **body** | **String**|  | |

### Return type


null (empty response body)

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: text/plain
- **Accept**: Not defined

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |

## setUserContactConfigurationValueByKeyWithHttpInfo

> ApiResponse<Void> setUserContactConfigurationValueByKey setUserContactConfigurationValueByKeyWithHttpInfo(key, body)

Set User Contact Configuration Value By Key

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,user&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.ApiResponse;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.UserApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        UserApi apiInstance = new UserApi(defaultClient);
        String key = "key_example"; // String | 
        String body = "body_example"; // String | 
        try {
            ApiResponse<Void> response = apiInstance.setUserContactConfigurationValueByKeyWithHttpInfo(key, body);
            System.out.println("Status code: " + response.getStatusCode());
            System.out.println("Response headers: " + response.getHeaders());
        } catch (ApiException e) {
            System.err.println("Exception when calling UserApi#setUserContactConfigurationValueByKey");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Response headers: " + e.getResponseHeaders());
            System.err.println("Reason: " + e.getResponseBody());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **key** | **String**|  | |
| **body** | **String**|  | |

### Return type


ApiResponse<Void>

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: text/plain
- **Accept**: Not defined

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |

