# LegacyApi

All URIs are relative to *http://localhost*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**acquireOrReleaseLocks**](LegacyApi.md#acquireOrReleaseLocks) | **POST** /services/elexis/lockservice/acquireOrReleaseLocks |  |
| [**acquireOrReleaseLocksWithHttpInfo**](LegacyApi.md#acquireOrReleaseLocksWithHttpInfo) | **POST** /services/elexis/lockservice/acquireOrReleaseLocks |  |
| [**getLockInfo**](LegacyApi.md#getLockInfo) | **GET** /services/elexis/lockservice/lockInfo |  |
| [**getLockInfoWithHttpInfo**](LegacyApi.md#getLockInfoWithHttpInfo) | **GET** /services/elexis/lockservice/lockInfo |  |
| [**getStatusJson**](LegacyApi.md#getStatusJson) | **GET** /services/elexis/instances/statusJson | Get Status Json |
| [**getStatusJsonWithHttpInfo**](LegacyApi.md#getStatusJsonWithHttpInfo) | **GET** /services/elexis/instances/statusJson | Get Status Json |
| [**isLocked**](LegacyApi.md#isLocked) | **POST** /services/elexis/lockservice/isLocked |  |
| [**isLockedWithHttpInfo**](LegacyApi.md#isLockedWithHttpInfo) | **POST** /services/elexis/lockservice/isLocked |  |
| [**postEvent**](LegacyApi.md#postEvent) | **POST** /services/elexis/eventservice/postEvent |  |
| [**postEventWithHttpInfo**](LegacyApi.md#postEventWithHttpInfo) | **POST** /services/elexis/eventservice/postEvent |  |



## acquireOrReleaseLocks

> LockResponse acquireOrReleaseLocks(lockRequest)



### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.LegacyApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");

        LegacyApi apiInstance = new LegacyApi(defaultClient);
        LockRequest lockRequest = new LockRequest(); // LockRequest | 
        try {
            LockResponse result = apiInstance.acquireOrReleaseLocks(lockRequest);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling LegacyApi#acquireOrReleaseLocks");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **lockRequest** | [**LockRequest**](LockRequest.md)|  | |

### Return type

[**LockResponse**](LockResponse.md)


### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: application/xml
- **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |

## acquireOrReleaseLocksWithHttpInfo

> ApiResponse<LockResponse> acquireOrReleaseLocks acquireOrReleaseLocksWithHttpInfo(lockRequest)



### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.ApiResponse;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.LegacyApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");

        LegacyApi apiInstance = new LegacyApi(defaultClient);
        LockRequest lockRequest = new LockRequest(); // LockRequest | 
        try {
            ApiResponse<LockResponse> response = apiInstance.acquireOrReleaseLocksWithHttpInfo(lockRequest);
            System.out.println("Status code: " + response.getStatusCode());
            System.out.println("Response headers: " + response.getHeaders());
            System.out.println("Response body: " + response.getData());
        } catch (ApiException e) {
            System.err.println("Exception when calling LegacyApi#acquireOrReleaseLocks");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Response headers: " + e.getResponseHeaders());
            System.err.println("Reason: " + e.getResponseBody());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **lockRequest** | [**LockRequest**](LockRequest.md)|  | |

### Return type

ApiResponse<[**LockResponse**](LockResponse.md)>


### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: application/xml
- **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |


## getLockInfo

> LockInfo getLockInfo(objectId)



### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.LegacyApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");

        LegacyApi apiInstance = new LegacyApi(defaultClient);
        String objectId = "objectId_example"; // String | 
        try {
            LockInfo result = apiInstance.getLockInfo(objectId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling LegacyApi#getLockInfo");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **objectId** | **String**|  | [optional] |

### Return type

[**LockInfo**](LockInfo.md)


### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: text/plain

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |

## getLockInfoWithHttpInfo

> ApiResponse<LockInfo> getLockInfo getLockInfoWithHttpInfo(objectId)



### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.ApiResponse;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.LegacyApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");

        LegacyApi apiInstance = new LegacyApi(defaultClient);
        String objectId = "objectId_example"; // String | 
        try {
            ApiResponse<LockInfo> response = apiInstance.getLockInfoWithHttpInfo(objectId);
            System.out.println("Status code: " + response.getStatusCode());
            System.out.println("Response headers: " + response.getHeaders());
            System.out.println("Response body: " + response.getData());
        } catch (ApiException e) {
            System.err.println("Exception when calling LegacyApi#getLockInfo");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Response headers: " + e.getResponseHeaders());
            System.err.println("Reason: " + e.getResponseBody());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **objectId** | **String**|  | [optional] |

### Return type

ApiResponse<[**LockInfo**](LockInfo.md)>


### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: text/plain

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |


## getStatusJson

> List<InstanceStatus> getStatusJson()

Get Status Json

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,ict-administrator&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.LegacyApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        LegacyApi apiInstance = new LegacyApi(defaultClient);
        try {
            List<InstanceStatus> result = apiInstance.getStatusJson();
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling LegacyApi#getStatusJson");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**List&lt;InstanceStatus&gt;**](InstanceStatus.md)


### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |

## getStatusJsonWithHttpInfo

> ApiResponse<List<InstanceStatus>> getStatusJson getStatusJsonWithHttpInfo()

Get Status Json

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,ict-administrator&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.ApiResponse;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.LegacyApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        LegacyApi apiInstance = new LegacyApi(defaultClient);
        try {
            ApiResponse<List<InstanceStatus>> response = apiInstance.getStatusJsonWithHttpInfo();
            System.out.println("Status code: " + response.getStatusCode());
            System.out.println("Response headers: " + response.getHeaders());
            System.out.println("Response body: " + response.getData());
        } catch (ApiException e) {
            System.err.println("Exception when calling LegacyApi#getStatusJson");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Response headers: " + e.getResponseHeaders());
            System.err.println("Reason: " + e.getResponseBody());
            e.printStackTrace();
        }
    }
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

ApiResponse<[**List&lt;InstanceStatus&gt;**](InstanceStatus.md)>


### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## isLocked

> Boolean isLocked(lockRequest)



### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.LegacyApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");

        LegacyApi apiInstance = new LegacyApi(defaultClient);
        LockRequest lockRequest = new LockRequest(); // LockRequest | 
        try {
            Boolean result = apiInstance.isLocked(lockRequest);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling LegacyApi#isLocked");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **lockRequest** | [**LockRequest**](LockRequest.md)|  | |

### Return type

**Boolean**


### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: application/xml
- **Accept**: text/plain

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |

## isLockedWithHttpInfo

> ApiResponse<Boolean> isLocked isLockedWithHttpInfo(lockRequest)



### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.ApiResponse;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.LegacyApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");

        LegacyApi apiInstance = new LegacyApi(defaultClient);
        LockRequest lockRequest = new LockRequest(); // LockRequest | 
        try {
            ApiResponse<Boolean> response = apiInstance.isLockedWithHttpInfo(lockRequest);
            System.out.println("Status code: " + response.getStatusCode());
            System.out.println("Response headers: " + response.getHeaders());
            System.out.println("Response body: " + response.getData());
        } catch (ApiException e) {
            System.err.println("Exception when calling LegacyApi#isLocked");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Response headers: " + e.getResponseHeaders());
            System.err.println("Reason: " + e.getResponseBody());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **lockRequest** | [**LockRequest**](LockRequest.md)|  | |

### Return type

ApiResponse<**Boolean**>


### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: application/xml
- **Accept**: text/plain

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |


## postEvent

> void postEvent(elexisEvent)



### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.LegacyApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");

        LegacyApi apiInstance = new LegacyApi(defaultClient);
        ElexisEvent elexisEvent = new ElexisEvent(); // ElexisEvent | 
        try {
            apiInstance.postEvent(elexisEvent);
        } catch (ApiException e) {
            System.err.println("Exception when calling LegacyApi#postEvent");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **elexisEvent** | [**ElexisEvent**](ElexisEvent.md)|  | |

### Return type


null (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: application/xml
- **Accept**: Not defined

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |

## postEventWithHttpInfo

> ApiResponse<Void> postEvent postEventWithHttpInfo(elexisEvent)



### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.ApiResponse;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.LegacyApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");

        LegacyApi apiInstance = new LegacyApi(defaultClient);
        ElexisEvent elexisEvent = new ElexisEvent(); // ElexisEvent | 
        try {
            ApiResponse<Void> response = apiInstance.postEventWithHttpInfo(elexisEvent);
            System.out.println("Status code: " + response.getStatusCode());
            System.out.println("Response headers: " + response.getHeaders());
        } catch (ApiException e) {
            System.err.println("Exception when calling LegacyApi#postEvent");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Response headers: " + e.getResponseHeaders());
            System.err.println("Reason: " + e.getResponseBody());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **elexisEvent** | [**ElexisEvent**](ElexisEvent.md)|  | |

### Return type


ApiResponse<Void>

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: application/xml
- **Accept**: Not defined

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |

