# ConfigApi

All URIs are relative to *http://localhost*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**deleteUserContactConfigurationEntryByKey**](ConfigApi.md#deleteUserContactConfigurationEntryByKey) | **DELETE** /api/v1/user/config/contact | Delete User Contact Configuration Entry By Key |
| [**deleteUserContactConfigurationEntryByKeyWithHttpInfo**](ConfigApi.md#deleteUserContactConfigurationEntryByKeyWithHttpInfo) | **DELETE** /api/v1/user/config/contact | Delete User Contact Configuration Entry By Key |
| [**findGlobalConfigurationDirectSubnodeKeysForGivenKey**](ConfigApi.md#findGlobalConfigurationDirectSubnodeKeysForGivenKey) | **GET** /api/v1/user/config/global-subnodekeys | Find the direct subnode keys for a given entry branch. Programmatically limited to specific branches. |
| [**findGlobalConfigurationDirectSubnodeKeysForGivenKeyWithHttpInfo**](ConfigApi.md#findGlobalConfigurationDirectSubnodeKeysForGivenKeyWithHttpInfo) | **GET** /api/v1/user/config/global-subnodekeys | Find the direct subnode keys for a given entry branch. Programmatically limited to specific branches. |
| [**getContactConfigurationEntries**](ConfigApi.md#getContactConfigurationEntries) | **GET** /api/v1/management/config/contact/{contactid} | Get Contact Configuration Entries |
| [**getContactConfigurationEntriesWithHttpInfo**](ConfigApi.md#getContactConfigurationEntriesWithHttpInfo) | **GET** /api/v1/management/config/contact/{contactid} | Get Contact Configuration Entries |
| [**getGlobalConfiguration**](ConfigApi.md#getGlobalConfiguration) | **GET** /api/v1/management/config/global | Return the global configuration tree |
| [**getGlobalConfigurationWithHttpInfo**](ConfigApi.md#getGlobalConfigurationWithHttpInfo) | **GET** /api/v1/management/config/global | Return the global configuration tree |
| [**getGlobalConfigurationValueByKey**](ConfigApi.md#getGlobalConfigurationValueByKey) | **GET** /api/v1/user/config/global | Get Global Configuration Value By Key |
| [**getGlobalConfigurationValueByKeyWithHttpInfo**](ConfigApi.md#getGlobalConfigurationValueByKeyWithHttpInfo) | **GET** /api/v1/user/config/global | Get Global Configuration Value By Key |
| [**getUserContactConfigurationAsTree**](ConfigApi.md#getUserContactConfigurationAsTree) | **GET** /api/v1/management/config/usercontact | Return the configuration tree of a user contact. If no param provided, returns a list of all user-contact-ids with configuration values. |
| [**getUserContactConfigurationAsTreeWithHttpInfo**](ConfigApi.md#getUserContactConfigurationAsTreeWithHttpInfo) | **GET** /api/v1/management/config/usercontact | Return the configuration tree of a user contact. If no param provided, returns a list of all user-contact-ids with configuration values. |
| [**getUserContactConfigurationValueByKey**](ConfigApi.md#getUserContactConfigurationValueByKey) | **GET** /api/v1/user/config/contact | Get User Contact Configuration Value By Key |
| [**getUserContactConfigurationValueByKeyWithHttpInfo**](ConfigApi.md#getUserContactConfigurationValueByKeyWithHttpInfo) | **GET** /api/v1/user/config/contact | Get User Contact Configuration Value By Key |
| [**setContactConfiguration**](ConfigApi.md#setContactConfiguration) | **POST** /api/v1/management/config/contact/{contactid} | Update contact configuration |
| [**setContactConfigurationWithHttpInfo**](ConfigApi.md#setContactConfigurationWithHttpInfo) | **POST** /api/v1/management/config/contact/{contactid} | Update contact configuration |
| [**setGlobalConfigurationValueByKey**](ConfigApi.md#setGlobalConfigurationValueByKey) | **PUT** /api/v1/user/config/global | Set Global Configuration Value By Key |
| [**setGlobalConfigurationValueByKeyWithHttpInfo**](ConfigApi.md#setGlobalConfigurationValueByKeyWithHttpInfo) | **PUT** /api/v1/user/config/global | Set Global Configuration Value By Key |
| [**setUserContactConfigurationValueByKey**](ConfigApi.md#setUserContactConfigurationValueByKey) | **PUT** /api/v1/user/config/contact | Set User Contact Configuration Value By Key |
| [**setUserContactConfigurationValueByKeyWithHttpInfo**](ConfigApi.md#setUserContactConfigurationValueByKeyWithHttpInfo) | **PUT** /api/v1/user/config/contact | Set User Contact Configuration Value By Key |
| [**updateGlobalConfigByJson**](ConfigApi.md#updateGlobalConfigByJson) | **PUT** /api/v1/management/config/global | Update Global Config By Json |
| [**updateGlobalConfigByJsonWithHttpInfo**](ConfigApi.md#updateGlobalConfigByJsonWithHttpInfo) | **PUT** /api/v1/management/config/global | Update Global Config By Json |



## deleteUserContactConfigurationEntryByKey

> void deleteUserContactConfigurationEntryByKey(key)

Delete User Contact Configuration Entry By Key

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,user&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.ConfigApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        ConfigApi apiInstance = new ConfigApi(defaultClient);
        String key = "key_example"; // String | 
        try {
            apiInstance.deleteUserContactConfigurationEntryByKey(key);
        } catch (ApiException e) {
            System.err.println("Exception when calling ConfigApi#deleteUserContactConfigurationEntryByKey");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **key** | **String**|  | |

### Return type


null (empty response body)

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |

## deleteUserContactConfigurationEntryByKeyWithHttpInfo

> ApiResponse<Void> deleteUserContactConfigurationEntryByKey deleteUserContactConfigurationEntryByKeyWithHttpInfo(key)

Delete User Contact Configuration Entry By Key

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,user&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.ApiResponse;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.ConfigApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        ConfigApi apiInstance = new ConfigApi(defaultClient);
        String key = "key_example"; // String | 
        try {
            ApiResponse<Void> response = apiInstance.deleteUserContactConfigurationEntryByKeyWithHttpInfo(key);
            System.out.println("Status code: " + response.getStatusCode());
            System.out.println("Response headers: " + response.getHeaders());
        } catch (ApiException e) {
            System.err.println("Exception when calling ConfigApi#deleteUserContactConfigurationEntryByKey");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Response headers: " + e.getResponseHeaders());
            System.err.println("Reason: " + e.getResponseBody());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **key** | **String**|  | |

### Return type


ApiResponse<Void>

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## findGlobalConfigurationDirectSubnodeKeysForGivenKey

> List<String> findGlobalConfigurationDirectSubnodeKeysForGivenKey(key)

Find the direct subnode keys for a given entry branch. Programmatically limited to specific branches.

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,user&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.ConfigApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        ConfigApi apiInstance = new ConfigApi(defaultClient);
        String key = "key_example"; // String | 
        try {
            List<String> result = apiInstance.findGlobalConfigurationDirectSubnodeKeysForGivenKey(key);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling ConfigApi#findGlobalConfigurationDirectSubnodeKeysForGivenKey");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **key** | **String**|  | |

### Return type

**List&lt;String&gt;**


### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |

## findGlobalConfigurationDirectSubnodeKeysForGivenKeyWithHttpInfo

> ApiResponse<List<String>> findGlobalConfigurationDirectSubnodeKeysForGivenKey findGlobalConfigurationDirectSubnodeKeysForGivenKeyWithHttpInfo(key)

Find the direct subnode keys for a given entry branch. Programmatically limited to specific branches.

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,user&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.ApiResponse;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.ConfigApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        ConfigApi apiInstance = new ConfigApi(defaultClient);
        String key = "key_example"; // String | 
        try {
            ApiResponse<List<String>> response = apiInstance.findGlobalConfigurationDirectSubnodeKeysForGivenKeyWithHttpInfo(key);
            System.out.println("Status code: " + response.getStatusCode());
            System.out.println("Response headers: " + response.getHeaders());
            System.out.println("Response body: " + response.getData());
        } catch (ApiException e) {
            System.err.println("Exception when calling ConfigApi#findGlobalConfigurationDirectSubnodeKeysForGivenKey");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Response headers: " + e.getResponseHeaders());
            System.err.println("Reason: " + e.getResponseBody());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **key** | **String**|  | |

### Return type

ApiResponse<**List&lt;String&gt;**>


### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## getContactConfigurationEntries

> Map<String, String> getContactConfigurationEntries(contactid)

Get Contact Configuration Entries

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,ict-administrator&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.ConfigApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        ConfigApi apiInstance = new ConfigApi(defaultClient);
        String contactid = "contactid_example"; // String | 
        try {
            Map<String, String> result = apiInstance.getContactConfigurationEntries(contactid);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling ConfigApi#getContactConfigurationEntries");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **contactid** | **String**|  | |

### Return type

**Map&lt;String, String&gt;**


### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |

## getContactConfigurationEntriesWithHttpInfo

> ApiResponse<Map<String, String>> getContactConfigurationEntries getContactConfigurationEntriesWithHttpInfo(contactid)

Get Contact Configuration Entries

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,ict-administrator&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.ApiResponse;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.ConfigApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        ConfigApi apiInstance = new ConfigApi(defaultClient);
        String contactid = "contactid_example"; // String | 
        try {
            ApiResponse<Map<String, String>> response = apiInstance.getContactConfigurationEntriesWithHttpInfo(contactid);
            System.out.println("Status code: " + response.getStatusCode());
            System.out.println("Response headers: " + response.getHeaders());
            System.out.println("Response body: " + response.getData());
        } catch (ApiException e) {
            System.err.println("Exception when calling ConfigApi#getContactConfigurationEntries");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Response headers: " + e.getResponseHeaders());
            System.err.println("Reason: " + e.getResponseBody());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **contactid** | **String**|  | |

### Return type

ApiResponse<**Map&lt;String, String&gt;**>


### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## getGlobalConfiguration

> void getGlobalConfiguration(format)

Return the global configuration tree

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,ict-administrator&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.ConfigApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        ConfigApi apiInstance = new ConfigApi(defaultClient);
        String format = "json"; // String | The format of the response, json (key, values) or json-tree (defaults to json)
        try {
            apiInstance.getGlobalConfiguration(format);
        } catch (ApiException e) {
            System.err.println("Exception when calling ConfigApi#getGlobalConfiguration");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **format** | **String**| The format of the response, json (key, values) or json-tree (defaults to json) | [optional] [default to json] |

### Return type


null (empty response body)

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |

## getGlobalConfigurationWithHttpInfo

> ApiResponse<Void> getGlobalConfiguration getGlobalConfigurationWithHttpInfo(format)

Return the global configuration tree

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,ict-administrator&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.ApiResponse;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.ConfigApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        ConfigApi apiInstance = new ConfigApi(defaultClient);
        String format = "json"; // String | The format of the response, json (key, values) or json-tree (defaults to json)
        try {
            ApiResponse<Void> response = apiInstance.getGlobalConfigurationWithHttpInfo(format);
            System.out.println("Status code: " + response.getStatusCode());
            System.out.println("Response headers: " + response.getHeaders());
        } catch (ApiException e) {
            System.err.println("Exception when calling ConfigApi#getGlobalConfiguration");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Response headers: " + e.getResponseHeaders());
            System.err.println("Reason: " + e.getResponseBody());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **format** | **String**| The format of the response, json (key, values) or json-tree (defaults to json) | [optional] [default to json] |

### Return type


ApiResponse<Void>

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## getGlobalConfigurationValueByKey

> String getGlobalConfigurationValueByKey(key)

Get Global Configuration Value By Key

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,user&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.ConfigApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        ConfigApi apiInstance = new ConfigApi(defaultClient);
        String key = "key_example"; // String | 
        try {
            String result = apiInstance.getGlobalConfigurationValueByKey(key);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling ConfigApi#getGlobalConfigurationValueByKey");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **key** | **String**|  | |

### Return type

**String**


### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: text/plain

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |

## getGlobalConfigurationValueByKeyWithHttpInfo

> ApiResponse<String> getGlobalConfigurationValueByKey getGlobalConfigurationValueByKeyWithHttpInfo(key)

Get Global Configuration Value By Key

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,user&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.ApiResponse;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.ConfigApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        ConfigApi apiInstance = new ConfigApi(defaultClient);
        String key = "key_example"; // String | 
        try {
            ApiResponse<String> response = apiInstance.getGlobalConfigurationValueByKeyWithHttpInfo(key);
            System.out.println("Status code: " + response.getStatusCode());
            System.out.println("Response headers: " + response.getHeaders());
            System.out.println("Response body: " + response.getData());
        } catch (ApiException e) {
            System.err.println("Exception when calling ConfigApi#getGlobalConfigurationValueByKey");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Response headers: " + e.getResponseHeaders());
            System.err.println("Reason: " + e.getResponseBody());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **key** | **String**|  | |

### Return type

ApiResponse<**String**>


### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: text/plain

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## getUserContactConfigurationAsTree

> void getUserContactConfigurationAsTree(userContactId, userId)

Return the configuration tree of a user contact. If no param provided, returns a list of all user-contact-ids with configuration values.

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,ict-administrator&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.ConfigApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        ConfigApi apiInstance = new ConfigApi(defaultClient);
        String userContactId = "userContactId_example"; // String | The id of a users associated-contact
        String userId = "userId_example"; // String | The id of a user (its associated contact will be used). Setting this will override `user-contact-id`
        try {
            apiInstance.getUserContactConfigurationAsTree(userContactId, userId);
        } catch (ApiException e) {
            System.err.println("Exception when calling ConfigApi#getUserContactConfigurationAsTree");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **userContactId** | **String**| The id of a users associated-contact | [optional] |
| **userId** | **String**| The id of a user (its associated contact will be used). Setting this will override &#x60;user-contact-id&#x60; | [optional] |

### Return type


null (empty response body)

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |

## getUserContactConfigurationAsTreeWithHttpInfo

> ApiResponse<Void> getUserContactConfigurationAsTree getUserContactConfigurationAsTreeWithHttpInfo(userContactId, userId)

Return the configuration tree of a user contact. If no param provided, returns a list of all user-contact-ids with configuration values.

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,ict-administrator&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.ApiResponse;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.ConfigApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        ConfigApi apiInstance = new ConfigApi(defaultClient);
        String userContactId = "userContactId_example"; // String | The id of a users associated-contact
        String userId = "userId_example"; // String | The id of a user (its associated contact will be used). Setting this will override `user-contact-id`
        try {
            ApiResponse<Void> response = apiInstance.getUserContactConfigurationAsTreeWithHttpInfo(userContactId, userId);
            System.out.println("Status code: " + response.getStatusCode());
            System.out.println("Response headers: " + response.getHeaders());
        } catch (ApiException e) {
            System.err.println("Exception when calling ConfigApi#getUserContactConfigurationAsTree");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Response headers: " + e.getResponseHeaders());
            System.err.println("Reason: " + e.getResponseBody());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **userContactId** | **String**| The id of a users associated-contact | [optional] |
| **userId** | **String**| The id of a user (its associated contact will be used). Setting this will override &#x60;user-contact-id&#x60; | [optional] |

### Return type


ApiResponse<Void>

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## getUserContactConfigurationValueByKey

> String getUserContactConfigurationValueByKey(key, contactId)

Get User Contact Configuration Value By Key

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,user&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.ConfigApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        ConfigApi apiInstance = new ConfigApi(defaultClient);
        String key = "key_example"; // String | 
        String contactId = "contactId_example"; // String | Target contact to fetch value for. Limited to self and contact user is aobo
        try {
            String result = apiInstance.getUserContactConfigurationValueByKey(key, contactId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling ConfigApi#getUserContactConfigurationValueByKey");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **key** | **String**|  | |
| **contactId** | **String**| Target contact to fetch value for. Limited to self and contact user is aobo | [optional] |

### Return type

**String**


### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: text/plain

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |

## getUserContactConfigurationValueByKeyWithHttpInfo

> ApiResponse<String> getUserContactConfigurationValueByKey getUserContactConfigurationValueByKeyWithHttpInfo(key, contactId)

Get User Contact Configuration Value By Key

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,user&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.ApiResponse;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.ConfigApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        ConfigApi apiInstance = new ConfigApi(defaultClient);
        String key = "key_example"; // String | 
        String contactId = "contactId_example"; // String | Target contact to fetch value for. Limited to self and contact user is aobo
        try {
            ApiResponse<String> response = apiInstance.getUserContactConfigurationValueByKeyWithHttpInfo(key, contactId);
            System.out.println("Status code: " + response.getStatusCode());
            System.out.println("Response headers: " + response.getHeaders());
            System.out.println("Response body: " + response.getData());
        } catch (ApiException e) {
            System.err.println("Exception when calling ConfigApi#getUserContactConfigurationValueByKey");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Response headers: " + e.getResponseHeaders());
            System.err.println("Reason: " + e.getResponseBody());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **key** | **String**|  | |
| **contactId** | **String**| Target contact to fetch value for. Limited to self and contact user is aobo | [optional] |

### Return type

ApiResponse<**String**>


### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: text/plain

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## setContactConfiguration

> void setContactConfiguration(contactid, requestBody)

Update contact configuration

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,ict-administrator&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.ConfigApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        ConfigApi apiInstance = new ConfigApi(defaultClient);
        String contactid = "contactid_example"; // String | 
        Map<String, String> requestBody = new HashMap(); // Map<String, String> | 
        try {
            apiInstance.setContactConfiguration(contactid, requestBody);
        } catch (ApiException e) {
            System.err.println("Exception when calling ConfigApi#setContactConfiguration");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **contactid** | **String**|  | |
| **requestBody** | [**Map&lt;String, String&gt;**](String.md)|  | |

### Return type


null (empty response body)

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: Not defined

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |
| **400** | Bad Request |  -  |

## setContactConfigurationWithHttpInfo

> ApiResponse<Void> setContactConfiguration setContactConfigurationWithHttpInfo(contactid, requestBody)

Update contact configuration

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,ict-administrator&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.ApiResponse;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.ConfigApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        ConfigApi apiInstance = new ConfigApi(defaultClient);
        String contactid = "contactid_example"; // String | 
        Map<String, String> requestBody = new HashMap(); // Map<String, String> | 
        try {
            ApiResponse<Void> response = apiInstance.setContactConfigurationWithHttpInfo(contactid, requestBody);
            System.out.println("Status code: " + response.getStatusCode());
            System.out.println("Response headers: " + response.getHeaders());
        } catch (ApiException e) {
            System.err.println("Exception when calling ConfigApi#setContactConfiguration");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Response headers: " + e.getResponseHeaders());
            System.err.println("Reason: " + e.getResponseBody());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **contactid** | **String**|  | |
| **requestBody** | [**Map&lt;String, String&gt;**](String.md)|  | |

### Return type


ApiResponse<Void>

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: Not defined

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |
| **400** | Bad Request |  -  |


## setGlobalConfigurationValueByKey

> String setGlobalConfigurationValueByKey(key, body)

Set Global Configuration Value By Key

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,user&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.ConfigApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        ConfigApi apiInstance = new ConfigApi(defaultClient);
        String key = "key_example"; // String | 
        String body = "body_example"; // String | 
        try {
            String result = apiInstance.setGlobalConfigurationValueByKey(key, body);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling ConfigApi#setGlobalConfigurationValueByKey");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **key** | **String**|  | |
| **body** | **String**|  | |

### Return type

**String**


### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: text/plain
- **Accept**: text/plain

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |

## setGlobalConfigurationValueByKeyWithHttpInfo

> ApiResponse<String> setGlobalConfigurationValueByKey setGlobalConfigurationValueByKeyWithHttpInfo(key, body)

Set Global Configuration Value By Key

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,user&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.ApiResponse;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.ConfigApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        ConfigApi apiInstance = new ConfigApi(defaultClient);
        String key = "key_example"; // String | 
        String body = "body_example"; // String | 
        try {
            ApiResponse<String> response = apiInstance.setGlobalConfigurationValueByKeyWithHttpInfo(key, body);
            System.out.println("Status code: " + response.getStatusCode());
            System.out.println("Response headers: " + response.getHeaders());
            System.out.println("Response body: " + response.getData());
        } catch (ApiException e) {
            System.err.println("Exception when calling ConfigApi#setGlobalConfigurationValueByKey");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Response headers: " + e.getResponseHeaders());
            System.err.println("Reason: " + e.getResponseBody());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **key** | **String**|  | |
| **body** | **String**|  | |

### Return type

ApiResponse<**String**>


### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: text/plain
- **Accept**: text/plain

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## setUserContactConfigurationValueByKey

> void setUserContactConfigurationValueByKey(key, body)

Set User Contact Configuration Value By Key

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,user&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.ConfigApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        ConfigApi apiInstance = new ConfigApi(defaultClient);
        String key = "key_example"; // String | 
        String body = "body_example"; // String | 
        try {
            apiInstance.setUserContactConfigurationValueByKey(key, body);
        } catch (ApiException e) {
            System.err.println("Exception when calling ConfigApi#setUserContactConfigurationValueByKey");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **key** | **String**|  | |
| **body** | **String**|  | |

### Return type


null (empty response body)

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: text/plain
- **Accept**: Not defined

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |

## setUserContactConfigurationValueByKeyWithHttpInfo

> ApiResponse<Void> setUserContactConfigurationValueByKey setUserContactConfigurationValueByKeyWithHttpInfo(key, body)

Set User Contact Configuration Value By Key

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,user&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.ApiResponse;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.ConfigApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        ConfigApi apiInstance = new ConfigApi(defaultClient);
        String key = "key_example"; // String | 
        String body = "body_example"; // String | 
        try {
            ApiResponse<Void> response = apiInstance.setUserContactConfigurationValueByKeyWithHttpInfo(key, body);
            System.out.println("Status code: " + response.getStatusCode());
            System.out.println("Response headers: " + response.getHeaders());
        } catch (ApiException e) {
            System.err.println("Exception when calling ConfigApi#setUserContactConfigurationValueByKey");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Response headers: " + e.getResponseHeaders());
            System.err.println("Reason: " + e.getResponseBody());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **key** | **String**|  | |
| **body** | **String**|  | |

### Return type


ApiResponse<Void>

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: text/plain
- **Accept**: Not defined

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## updateGlobalConfigByJson

> void updateGlobalConfigByJson(body)

Update Global Config By Json

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,ict-administrator&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.ConfigApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        ConfigApi apiInstance = new ConfigApi(defaultClient);
        String body = "body_example"; // String | A (partial) config json. Keys with value `null` will be deleted. Add `\"dry-run\": true` to perform a dry-run.
        try {
            apiInstance.updateGlobalConfigByJson(body);
        } catch (ApiException e) {
            System.err.println("Exception when calling ConfigApi#updateGlobalConfigByJson");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **body** | **String**| A (partial) config json. Keys with value &#x60;null&#x60; will be deleted. Add &#x60;\&quot;dry-run\&quot;: true&#x60; to perform a dry-run. | |

### Return type


null (empty response body)

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: Not defined

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |

## updateGlobalConfigByJsonWithHttpInfo

> ApiResponse<Void> updateGlobalConfigByJson updateGlobalConfigByJsonWithHttpInfo(body)

Update Global Config By Json

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,ict-administrator&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.ApiResponse;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.ConfigApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        ConfigApi apiInstance = new ConfigApi(defaultClient);
        String body = "body_example"; // String | A (partial) config json. Keys with value `null` will be deleted. Add `\"dry-run\": true` to perform a dry-run.
        try {
            ApiResponse<Void> response = apiInstance.updateGlobalConfigByJsonWithHttpInfo(body);
            System.out.println("Status code: " + response.getStatusCode());
            System.out.println("Response headers: " + response.getHeaders());
        } catch (ApiException e) {
            System.err.println("Exception when calling ConfigApi#updateGlobalConfigByJson");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Response headers: " + e.getResponseHeaders());
            System.err.println("Reason: " + e.getResponseBody());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **body** | **String**| A (partial) config json. Keys with value &#x60;null&#x60; will be deleted. Add &#x60;\&quot;dry-run\&quot;: true&#x60; to perform a dry-run. | |

### Return type


ApiResponse<Void>

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: Not defined

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |

