/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.eigendiagnosen.model.service;

import ch.elexis.core.common.ElexisEvent;
import ch.elexis.core.eigendiagnosen.model.service.DiagnosisModelAdapterFactory;
import ch.elexis.core.eigendiagnosen.model.service.DiagnosisQuery;
import ch.elexis.core.eigendiagnosen.model.service.ElexisTypeMap;
import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.model.adapter.AbstractIdModelAdapter;
import ch.elexis.core.jpa.model.adapter.AbstractModelService;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IElexisEntityManager;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.IStoreToStringContribution;
import jakarta.persistence.EntityManager;
import java.util.Optional;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.event.EventAdmin;
import org.slf4j.LoggerFactory;

@Component(property={"service.model.name=ch.elexis.core.eigendiagnosen.model"})
public class DiagnosisModelService
extends AbstractModelService
implements IModelService,
IStoreToStringContribution {
    @Reference(cardinality=ReferenceCardinality.MANDATORY, target="(id=default)")
    private IElexisEntityManager entityManager;
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService coreModelService;
    @Reference
    private EventAdmin eventAdmin;

    protected EntityManager getEntityManager(boolean managed) {
        return (EntityManager)this.entityManager.getEntityManager(managed);
    }

    protected void closeEntityManager(EntityManager entityManager) {
        this.entityManager.closeEntityManager((Object)entityManager);
    }

    protected EventAdmin getEventAdmin() {
        return this.eventAdmin;
    }

    @Activate
    public void activate() {
        this.adapterFactory = DiagnosisModelAdapterFactory.getInstance();
    }

    public Optional<String> storeToString(Identifiable identifiable) {
        String classKey = null;
        Optional dbObject = this.getDbObject(identifiable);
        if (dbObject.isPresent() && (classKey = ElexisTypeMap.getKeyForObject((EntityWithId)dbObject.get())) != null) {
            return Optional.of(classKey + "::" + identifiable.getId());
        }
        return Optional.empty();
    }

    public Optional<Identifiable> loadFromString(String storeToString) {
        if (storeToString == null) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("StoreToString is null");
            return Optional.empty();
        }
        if (storeToString.startsWith("ch.elexis.data")) {
            String[] split = this.splitIntoTypeAndId(storeToString);
            String className = split[0];
            String id = split[1];
            Class<? extends EntityWithId> clazz = ElexisTypeMap.get(className);
            if (clazz != null) {
                EntityManager em = (EntityManager)this.entityManager.getEntityManager();
                EntityWithId dbObject = (EntityWithId)em.find(clazz, (Object)id);
                return Optional.ofNullable(this.adapterFactory.getModelAdapter(dbObject, null, false).orElse(null));
            }
        }
        return Optional.empty();
    }

    public <T> IQuery<T> getQuery(Class<T> clazz, boolean refreshCache, boolean includeDeleted) {
        return new DiagnosisQuery<T>(clazz, refreshCache, (EntityManager)this.entityManager.getEntityManager(), includeDeleted);
    }

    protected ElexisEvent getCreateEvent(Identifiable identifiable) {
        ElexisEvent ee = new ElexisEvent();
        ee.setTopic("info/elexis/po/create");
        if (identifiable instanceof AbstractIdModelAdapter) {
            EntityWithId dbObject = ((AbstractIdModelAdapter)identifiable).getEntity();
            ee.getProperties().put("id", dbObject.getId());
            ee.getProperties().put("class", ElexisTypeMap.getKeyForObject(dbObject));
        }
        return ee;
    }

    public void clearCache() {
        this.entityManager.clearCache();
    }

    public Class<?> getEntityForType(String type) {
        return ElexisTypeMap.get(type);
    }

    public String getTypeForEntity(Object entityInstance) {
        return ElexisTypeMap.getKeyForObject((EntityWithId)entityInstance);
    }

    public String getTypeForModel(Class<?> interfaze) {
        Class entityClass = this.adapterFactory.getEntityClass(interfaze);
        if (entityClass != null) {
            try {
                return this.getTypeForEntity(entityClass.newInstance());
            }
            catch (IllegalAccessException | InstantiationException e) {
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Error getting type for model [" + String.valueOf(interfaze) + "]", (Throwable)e);
            }
        }
        return null;
    }

    protected IModelService getCoreModelService() {
        return this.coreModelService;
    }
}

