/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.p2;

import java.net.URI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.operations.ProvisioningJob;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.UpdateOperation;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;

public class P2Util {
    public static IStatus checkForUpdates(IProvisioningAgent agent, IProgressMonitor monitor) throws OperationCanceledException {
        System.out.println(">> checkForUpdates");
        ProvisioningSession session = new ProvisioningSession(agent);
        UpdateOperation operation = new UpdateOperation(session);
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)"Checking for application updates...", (int)200);
        return operation.resolveModal((IProgressMonitor)sub.newChild(100));
    }

    public static IStatus installUpdates(IProvisioningAgent agent, IProgressMonitor monitor) throws OperationCanceledException {
        ProvisioningSession session = new ProvisioningSession(agent);
        UpdateOperation operation = new UpdateOperation(session);
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)"Installing updates ...", (int)200);
        operation.resolveModal((IProgressMonitor)sub.newChild(100));
        ProvisioningJob job = operation.getProvisioningJob(monitor);
        return job.runModal((IProgressMonitor)sub.newChild(100));
    }

    public static boolean addRepository(IProvisioningAgent agent, String repo) {
        System.out.println(">> adding repository " + repo);
        IMetadataRepositoryManager metadataManager = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
        IArtifactRepositoryManager artifactManager = (IArtifactRepositoryManager)agent.getService(IArtifactRepositoryManager.SERVICE_NAME);
        if (metadataManager == null) {
            System.out.println("metadataManager is null!!!");
            return false;
        }
        if (artifactManager == null) {
            System.out.println("artifactManager is null!!!");
            return false;
        }
        try {
            URI uri = new URI(repo);
            metadataManager.addRepository(uri);
            artifactManager.addRepository(uri);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

