/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model;

import ch.elexis.core.jpa.entities.AUF;
import ch.elexis.core.jpa.entities.Brief;
import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.entities.Fall;
import ch.elexis.core.jpa.entities.Kontakt;
import ch.elexis.core.jpa.model.adapter.AbstractIdDeleteModelAdapter;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IDocumentLetter;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.ISickCertificate;
import ch.elexis.core.model.IdentifiableWithXid;
import ch.elexis.core.model.util.internal.ModelUtil;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import org.apache.commons.lang3.StringUtils;

public class SickCertificate
extends AbstractIdDeleteModelAdapter<AUF>
implements IdentifiableWithXid,
ISickCertificate {
    public SickCertificate(AUF entity) {
        super((EntityWithId)entity);
    }

    public IPatient getPatient() {
        return ModelUtil.getAdapter((EntityWithId)((AUF)this.getEntity()).getPatient(), IPatient.class);
    }

    public void setPatient(IPatient value) {
        if (value instanceof AbstractIdDeleteModelAdapter) {
            ((AUF)this.getEntityMarkDirty()).setPatient((Kontakt)((AbstractIdDeleteModelAdapter)value).getEntity());
        } else if (value == null) {
            ((AUF)this.getEntityMarkDirty()).setPatient(null);
        }
    }

    public ICoverage getCoverage() {
        return ModelUtil.getAdapter((EntityWithId)((AUF)this.getEntity()).getFall(), ICoverage.class);
    }

    public void setCoverage(ICoverage value) {
        if (value instanceof AbstractIdDeleteModelAdapter) {
            ((AUF)this.getEntityMarkDirty()).setFall((Fall)((AbstractIdDeleteModelAdapter)value).getEntity());
        } else if (value == null) {
            ((AUF)this.getEntityMarkDirty()).setFall(null);
        }
    }

    public IDocumentLetter getLetter() {
        return ModelUtil.getAdapter((EntityWithId)((AUF)this.getEntity()).getBrief(), IDocumentLetter.class);
    }

    public void setLetter(IDocumentLetter value) {
        if (value instanceof AbstractIdDeleteModelAdapter) {
            ((AUF)this.getEntityMarkDirty()).setBrief((Brief)((AbstractIdDeleteModelAdapter)value).getEntity());
        } else if (value == null) {
            ((AUF)this.getEntityMarkDirty()).setBrief(null);
        }
    }

    public int getPercent() {
        return ((AUF)this.getEntity()).getProzent();
    }

    public void setPercent(int value) {
        ((AUF)this.getEntityMarkDirty()).setProzent(value);
    }

    public LocalDate getDate() {
        return ((AUF)this.getEntity()).getDate();
    }

    public void setDate(LocalDate value) {
        ((AUF)this.getEntityMarkDirty()).setDate(value);
    }

    public LocalDate getStart() {
        return ((AUF)this.getEntity()).getDateFrom();
    }

    public void setStart(LocalDate value) {
        ((AUF)this.getEntityMarkDirty()).setDateFrom(value);
    }

    public LocalDate getEnd() {
        return ((AUF)this.getEntity()).getDateUntil();
    }

    public void setEnd(LocalDate value) {
        ((AUF)this.getEntityMarkDirty()).setDateUntil(value);
    }

    public String getReason() {
        return StringUtils.defaultString((String)((AUF)this.getEntity()).getReason());
    }

    public void setReason(String value) {
        ((AUF)this.getEntityMarkDirty()).setReason(value);
    }

    public String getNote() {
        return StringUtils.defaultString((String)((AUF)this.getEntity()).getNote());
    }

    public void setNote(String value) {
        ((AUF)this.getEntityMarkDirty()).setNote(value);
    }

    public String getLabel() {
        DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("dd.MM.yyyy");
        StringBuilder sb = new StringBuilder();
        if (this.getDate() != null) {
            sb.append("[").append(dateFormat.format(this.getDate())).append("]: ");
        }
        sb.append(dateFormat.format(this.getStart())).append("-").append(dateFormat.format(this.getEnd())).append(": ").append(this.getPercent()).append("% (").append(this.getReason()).append(")");
        return sb.toString();
    }
}

