/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.text.docx.util;

import ch.elexis.core.model.IImage;
import ch.elexis.core.text.ReplaceCallback;
import ch.elexis.core.text.docx.util.DocxUtil;
import ch.elexis.core.text.docx.util.ImageUtil;
import ch.elexis.core.text.docx.util.StyleInfo;
import ch.elexis.core.text.docx.util.TableUtil;
import ch.elexis.core.text.docx.util.TextUtil;
import jakarta.xml.bind.JAXBElement;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.utils.TraversalUtilVisitor;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.Text;
import org.slf4j.LoggerFactory;

public class RegexTextVisitor
extends TraversalUtilVisitor<Text> {
    private List<Text> foundElements = new ArrayList<Text>();
    private Pattern pattern;
    private StyleInfo styleInfo;
    private WordprocessingMLPackage currentDocument;

    public RegexTextVisitor(WordprocessingMLPackage currentDocument, String regex) {
        this.pattern = Pattern.compile(regex);
        this.styleInfo = new StyleInfo();
        this.currentDocument = currentDocument;
    }

    public RegexTextVisitor() {
    }

    public void apply(Text element) {
        if (this.pattern != null) {
            if (this.patternMatchesText(element.getValue())) {
                this.foundElements.add(element);
            }
        } else {
            this.foundElements.add(element);
        }
    }

    private boolean patternMatchesText(String text) {
        Matcher matcher = this.pattern.matcher(text);
        return matcher.find();
    }

    public List<Text> getFound() {
        return this.foundElements;
    }

    public void replaceMatchingTexts(ReplaceCallback replaceCallback) {
        for (Text text : this.foundElements) {
            String origText;
            Object cursor = this.getTextCursor(text);
            if (TextUtil.isMultiTextRun((R)cursor)) {
                TextUtil.convertToSingleTextRun((R)cursor);
                cursor = text.getParent();
            }
            String replaced = origText = text.getValue();
            Matcher matcher = this.pattern.matcher(origText);
            while (matcher.find()) {
                try {
                    Object replacement = replaceCallback.replace(replaced.substring(matcher.start(), matcher.end()));
                    if (replacement instanceof String) {
                        replaced = matcher.replaceFirst(Matcher.quoteReplacement((String)replacement));
                    } else if (replacement instanceof String[][]) {
                        Tbl table = TableUtil.insertTable((R)cursor, 0, (String[][])replacement, null, DocxUtil.getDocumentWidth(this.currentDocument), true);
                        TableUtil.addBorders(table, 1);
                        replaced = "";
                    } else if (replacement instanceof IImage) {
                        try {
                            ImageUtil.insertImage((R)cursor, (IImage)replacement, this.currentDocument);
                        }
                        catch (Exception e) {
                            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Error inserting image", (Throwable)e);
                        }
                        replaced = "";
                    } else if (replacement == null) {
                        replaced = matcher.replaceFirst(Matcher.quoteReplacement("??Auswahl??"));
                    }
                    matcher = this.pattern.matcher(replaced);
                }
                catch (Error | Exception e) {
                    LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Error repacing [" + replaced + "]", e);
                }
            }
            cursor = TextUtil.replaceText(cursor, replaced, 16384, this.styleInfo);
        }
    }

    private Object getTextCursor(Text text) {
        if (text.getParent() instanceof R && ((R)text.getParent()).getParent() instanceof P) {
            P parentP = (P)((R)text.getParent()).getParent();
            List pContents = parentP.getContent();
            for (Object pContent : pContents) {
                if (!(pContent instanceof R)) continue;
                R contentR = (R)pContent;
                List rContents = contentR.getContent();
                for (Object rContent : rContents) {
                    JAXBElement jaxbElement;
                    if (!(rContent instanceof JAXBElement) || (jaxbElement = (JAXBElement)rContent).getValue() != text) continue;
                    return contentR;
                }
            }
        }
        return text.getParent();
    }
}

