/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.jpa.liquibase;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import javax.sql.DataSource;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.LiquibaseException;
import liquibase.resource.OpenOptions;
import liquibase.resource.Resource;
import liquibase.resource.ResourceAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiquibaseDBScriptExecutor {
    private static Logger logger = LoggerFactory.getLogger(LiquibaseDBScriptExecutor.class);
    private DataSource dataSource;

    public LiquibaseDBScriptExecutor(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public boolean execute(String changeId, String sqlScript) {
        CustomResourceAccessor resourceAccessor = new CustomResourceAccessor();
        changeId = (String)changeId + ".xml";
        resourceAccessor.setContent((String)changeId, sqlScript);
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            JdbcConnection database = new JdbcConnection(connection);
            Database targetDb = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)database);
            Liquibase liquibase = new Liquibase((String)changeId, (ResourceAccessor)resourceAccessor, targetDb);
            liquibase.update("");
            liquibase.close();
            return true;
        }
        catch (SQLException | LiquibaseException e) {
            logger.warn("Exception on DB execute script [" + (String)changeId + "]", e);
            System.out.println("Exception on DB execute script [" + (String)changeId + "]");
            e.printStackTrace();
            return false;
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    private class CustomResourceAccessor
    implements ResourceAccessor {
        private StringBuilder stringBuilder = new StringBuilder();
        private String changeId;
        private Resource scriptResource;

        private CustomResourceAccessor() {
        }

        public void setContent(final String changeId, String script) {
            this.changeId = changeId;
            this.stringBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n<databaseChangeLog xmlns=\"http://www.liquibase.org/xml/ns/dbchangelog\" xmlns:ext=\"http://www.liquibase.org/xml/ns/dbchangelog-ext\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.liquibase.org/xml/ns/dbchangelog-ext http://www.liquibase.org/xml/ns/dbchangelog/dbchangelog-ext.xsd http://www.liquibase.org/xml/ns/dbchangelog http://www.liquibase.org/xml/ns/dbchangelog/dbchangelog-3.6.xsd\">\n");
            this.stringBuilder.append("<changeSet author=\"" + this.getClass().getSimpleName() + "\" id=\"" + changeId.substring(0, changeId.lastIndexOf(46)) + "\">\n");
            this.stringBuilder.append("<sql dbms=\"h2\" splitStatements=\"true\" stripComments=\"true\">\n");
            this.stringBuilder.append(script);
            this.stringBuilder.append("\n</sql>");
            this.stringBuilder.append("\n</changeSet>");
            this.stringBuilder.append("\n</databaseChangeLog>");
            this.scriptResource = new Resource(){

                public Resource resolveSibling(String other) {
                    return null;
                }

                public Resource resolve(String other) {
                    return null;
                }

                public OutputStream openOutputStream(OpenOptions openOptions) throws IOException {
                    return null;
                }

                public InputStream openInputStream() throws IOException {
                    return new ByteArrayInputStream(CustomResourceAccessor.this.stringBuilder.toString().getBytes(StandardCharsets.UTF_8));
                }

                public boolean isWritable() {
                    return false;
                }

                public URI getUri() {
                    try {
                        return new URI(changeId);
                    }
                    catch (URISyntaxException e) {
                        LoggerFactory.getLogger(this.getClass()).error("Error getting changeid uri");
                        return null;
                    }
                }

                public String getPath() {
                    return changeId;
                }

                public boolean exists() {
                    return true;
                }
            };
        }

        public void close() throws Exception {
        }

        public List<String> describeLocations() {
            return Collections.singletonList(this.changeId);
        }

        public List<Resource> getAll(String path) throws IOException {
            if (path.contains(this.changeId)) {
                return Collections.singletonList(this.scriptResource);
            }
            return Collections.emptyList();
        }

        public List<Resource> search(String path, boolean recursive) throws IOException {
            if (path.contains(this.changeId)) {
                return Collections.singletonList(this.scriptResource);
            }
            return Collections.emptyList();
        }
    }
}

