/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.impl.factory.primitive.IntLists;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionUtil;
import org.eclipse.nebula.widgets.nattable.group.model.IRowGroup;
import org.eclipse.nebula.widgets.nattable.group.model.IRowGroupModel;
import org.eclipse.nebula.widgets.nattable.group.performance.GroupModel;
import org.eclipse.nebula.widgets.nattable.group.performance.RowGroupHeaderLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LayerUtil;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;

public final class RowGroupUtils {
    private RowGroupUtils() {
    }

    public static <T> IRowGroup<T> getRowGroupForRowIndex(IRowGroupModel<T> model, int rowIndex) {
        T row = model.getRowFromIndexCache(rowIndex);
        return model.getRowGroupForRow(row);
    }

    public static <T> IRowGroup<T> getOwnRowGroupForRowIndex(IRowGroupModel<T> model, int rowIndex) {
        T row = model.getRowFromIndexCache(rowIndex);
        IRowGroup<T> rowGroup = model.getRowGroupForRow(row);
        if (rowGroup != null && !rowGroup.getOwnMemberRows(true).contains(row)) {
            rowGroup = rowGroup.getRowGroupForRow(row);
        }
        return rowGroup;
    }

    public static <T> boolean isPartOfAGroup(IRowGroupModel<T> model, int rowIndex) {
        T row = model.getRowFromIndexCache(rowIndex);
        if (row != null) {
            return model.getRowGroupForRow(row) != null;
        }
        return false;
    }

    public static <T> boolean isInTheSameGroup(int fromRowIndex, int toRowIndex, IRowGroupModel<T> model) {
        T fromRow = model.getRowFromIndexCache(fromRowIndex);
        T toRow = model.getRowFromIndexCache(toRowIndex);
        IRowGroup<T> rowGroupFrom = RowGroupUtils.getTopMostParentGroup(model.getRowGroupForRow(fromRow));
        IRowGroup<T> rowGroupTo = RowGroupUtils.getTopMostParentGroup(model.getRowGroupForRow(toRow));
        return rowGroupFrom != null && rowGroupTo != null && rowGroupFrom.equals(rowGroupTo);
    }

    public static <T> boolean isCollapsed(IRowGroupModel<T> model, IRowGroup<T> group) {
        return group == null || group.isCollapsed() || RowGroupUtils.isAnyParentCollapsed(group);
    }

    public static <T> boolean isAnyParentCollapsed(IRowGroup<T> group) {
        boolean collapsed = false;
        if (group != null) {
            IRowGroup<T> topMostGroup = RowGroupUtils.getTopMostParentGroup(group);
            while (!collapsed && group != topMostGroup) {
                if ((group = group.getParentGroup()) == null) break;
                collapsed = group.isCollapsed();
            }
        }
        return collapsed;
    }

    public static <T> int sizeOfGroup(IRowGroupModel<T> model, int bodyRowIndex) {
        IRowGroup<T> group = RowGroupUtils.getRowGroupForRowIndex(model, bodyRowIndex);
        if (group != null) {
            return RowGroupUtils.getTopMostParentGroup(group).getMemberRows(true).size();
        }
        return 0;
    }

    public static <T> IRowGroup<T> getTopMostParentGroup(IRowGroup<T> rowGroup) {
        return rowGroup == null ? null : (rowGroup.getParentGroup() == null ? rowGroup : RowGroupUtils.getTopMostParentGroup(rowGroup.getParentGroup()));
    }

    public static <T> boolean isStaticRow(IRowGroupModel<T> model, int bodyRowIndex) {
        IRowGroup<T> group;
        T row = model.getRowFromIndexCache(bodyRowIndex);
        if (row != null && (group = model.getRowGroupForRow(row)) != null) {
            return group.getStaticMemberRows().contains(row);
        }
        return false;
    }

    public static boolean isRowIndexHiddenInUnderLyingLayer(int rowIndex, ILayer layer, IUniqueIndexLayer underlyingLayer) {
        return underlyingLayer.getRowPositionByIndex(rowIndex) == -1;
    }

    public static List<Integer> getRowPositionsInGroup(IUniqueIndexLayer layer, Collection<Integer> bodyRowIndexes) {
        return Collections.unmodifiableList(bodyRowIndexes.stream().map(layer::getRowPositionByIndex).filter(pos -> pos != -1).sorted().collect(Collectors.toList()));
    }

    public static <T> List<Integer> getRowIndexesInGroup(IRowGroupModel<T> model, int rowIndex) {
        IRowGroup<T> group = RowGroupUtils.getRowGroupForRowIndex(model, rowIndex);
        return RowGroupUtils.getRowIndexesInGroup(model, group, true);
    }

    public static <T> List<Integer> getRowIndexesInGroup(IRowGroupModel<T> model, IRowGroup<T> group, boolean includeStatic) {
        return Collections.unmodifiableList(group.getMemberRows(includeStatic).stream().map(model::getIndexFromRowCache).sorted().collect(Collectors.toList()));
    }

    public static int[] getRowPositionsInGroup(IUniqueIndexLayer layer, int ... bodyRowIndexes) {
        return Arrays.stream(bodyRowIndexes).map(layer::getRowPositionByIndex).filter(pos -> pos != -1).sorted().toArray();
    }

    public static <T> int[] getRowIndexesInGroupAsArray(IRowGroupModel<T> model, int rowIndex) {
        IRowGroup<T> group = RowGroupUtils.getRowGroupForRowIndex(model, rowIndex);
        return RowGroupUtils.getRowIndexesInGroupAsArray(model, group, true);
    }

    public static <T> int[] getRowIndexesInGroupAsArray(IRowGroupModel<T> model, IRowGroup<T> group, boolean includeStatic) {
        return group.getMemberRows(includeStatic).stream().mapToInt(model::getIndexFromRowCache).sorted().toArray();
    }

    public static <T> String getRowGroupNameForIndex(IRowGroupModel<T> model, int bodyRowIndex) {
        IRowGroup<T> group = RowGroupUtils.getRowGroupForRowIndex(model, bodyRowIndex);
        if (group != null) {
            return group.getGroupName();
        }
        return null;
    }

    public static boolean isInTheSameGroup(RowGroupHeaderLayer layer, int level, int fromPosition, int toPosition) {
        GroupModel.Group fromGroup = layer.getGroupModel(level).getGroupByPosition(fromPosition);
        GroupModel.Group toGroup = layer.getGroupModel(level).getGroupByPosition(toPosition);
        return fromGroup != null && toGroup != null && fromGroup == toGroup;
    }

    public static boolean isBetweenTwoGroups(ILayer natLayer, int startY, int endY, RowGroupHeaderLayer layer, int level) {
        int toPosition;
        boolean result;
        int natFromPosition = natLayer.getRowPositionByY(startY);
        int natToPosition = natLayer.getRowPositionByY(endY);
        int fromPosition = LayerUtil.convertRowPosition(natLayer, natFromPosition, layer.getPositionLayer());
        boolean bl = result = !RowGroupUtils.isInTheSameGroup(layer, level, fromPosition, toPosition = LayerUtil.convertRowPosition(natLayer, natToPosition, layer.getPositionLayer()));
        if (!result && fromPosition == toPosition && natFromPosition < natToPosition) {
            result = true;
        }
        return result;
    }

    public static boolean isBetweenTwoGroups(RowGroupHeaderLayer rowGroupHeaderLayer, int toPosition, boolean reorderToTopEdge, SelectionLayer.MoveDirectionEnum moveDirection) {
        if (toPosition == 0 && reorderToTopEdge || toPosition == rowGroupHeaderLayer.getPositionLayer().getRowCount() - 1 && !reorderToTopEdge) {
            return true;
        }
        int toPositionToCheck = toPosition;
        if (reorderToTopEdge && SelectionLayer.MoveDirectionEnum.DOWN == moveDirection) {
            --toPositionToCheck;
        }
        boolean valid = true;
        int level = 0;
        while (level < rowGroupHeaderLayer.getLevelCount()) {
            if (SelectionLayer.MoveDirectionEnum.DOWN == moveDirection) {
                valid = !RowGroupUtils.isInTheSameGroup(rowGroupHeaderLayer, level, toPosition, toPositionToCheck);
            } else {
                boolean bl = valid = !RowGroupUtils.isInTheSameGroup(rowGroupHeaderLayer, level, toPosition, toPositionToCheck + (reorderToTopEdge ? -1 : 1));
            }
            if (!valid) break;
            ++level;
        }
        return valid;
    }

    public static boolean isBetweenTwoGroups(RowGroupHeaderLayer rowGroupHeaderLayer, int level, int toPosition, boolean reorderToTopEdge, SelectionLayer.MoveDirectionEnum moveDirection) {
        if (toPosition == 0 && reorderToTopEdge || toPosition == rowGroupHeaderLayer.getPositionLayer().getRowCount() - 1 && !reorderToTopEdge) {
            return true;
        }
        int toPositionToCheck = toPosition;
        if (SelectionLayer.MoveDirectionEnum.DOWN == moveDirection) {
            toPositionToCheck = reorderToTopEdge ? --toPositionToCheck : ++toPositionToCheck;
        }
        boolean valid = true;
        if (SelectionLayer.MoveDirectionEnum.DOWN == moveDirection) {
            valid = !RowGroupUtils.isInTheSameGroup(rowGroupHeaderLayer, level, toPosition, toPositionToCheck);
        } else {
            boolean bl = valid = !RowGroupUtils.isInTheSameGroup(rowGroupHeaderLayer, level, toPosition, toPositionToCheck + (reorderToTopEdge ? -1 : 1));
        }
        if (valid && level > 0) {
            valid = RowGroupUtils.isBetweenTwoGroups(rowGroupHeaderLayer, level - 1, toPosition, reorderToTopEdge, moveDirection);
        }
        return valid;
    }

    public static boolean isReorderValid(RowGroupHeaderLayer rowGroupHeaderLayer, int fromPosition, int toPosition, boolean reorderToTopEdge) {
        int level = 0;
        while (level < rowGroupHeaderLayer.getLevelCount()) {
            if (!RowGroupUtils.isReorderValid(rowGroupHeaderLayer, level, fromPosition, toPosition, reorderToTopEdge)) {
                return false;
            }
            ++level;
        }
        return true;
    }

    public static boolean isReorderValid(RowGroupHeaderLayer rowGroupHeaderLayer, int level, int fromPosition, int toPosition, boolean reorderToTopEdge) {
        SelectionLayer.MoveDirectionEnum moveDirection = PositionUtil.getVerticalMoveDirection(fromPosition, toPosition);
        int toPositionToCheck = toPosition;
        if (SelectionLayer.MoveDirectionEnum.DOWN == moveDirection && reorderToTopEdge || toPosition == rowGroupHeaderLayer.getPositionLayer().getRowCount() && !reorderToTopEdge) {
            --toPositionToCheck;
        }
        boolean fromUnbreakable = false;
        boolean valid = true;
        GroupModel model = rowGroupHeaderLayer.getGroupModel(level);
        GroupModel.Group group = model.getGroupByPosition(fromPosition);
        if (group != null && group.isUnbreakable() && group.getVisibleSpan() > 1) {
            fromUnbreakable = true;
            valid = RowGroupUtils.isInTheSameGroup(rowGroupHeaderLayer, level, fromPosition, toPositionToCheck);
        }
        if (!fromUnbreakable) {
            if (toPosition == 0 && reorderToTopEdge || toPosition == rowGroupHeaderLayer.getPositionLayer().getRowCount() - 1 && !reorderToTopEdge) {
                return true;
            }
            if (model.isPartOfAnUnbreakableGroup(toPositionToCheck)) {
                valid = SelectionLayer.MoveDirectionEnum.DOWN == moveDirection ? !RowGroupUtils.isInTheSameGroup(rowGroupHeaderLayer, level, toPosition, toPositionToCheck) : !RowGroupUtils.isInTheSameGroup(rowGroupHeaderLayer, level, toPosition, toPositionToCheck + (reorderToTopEdge ? -1 : 1));
            }
        }
        return valid;
    }

    public static boolean isGroupReordered(GroupModel.Group fromGroup, int[] fromPositions) {
        int[] visiblePositions = fromGroup.getVisiblePositions();
        if (visiblePositions.length > fromPositions.length) {
            return false;
        }
        if (visiblePositions.length < fromPositions.length) {
            MutableIntList from = IntLists.mutable.of(fromPositions);
            return from.containsAll(visiblePositions);
        }
        return Arrays.equals(visiblePositions, fromPositions);
    }
}

