/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.contacts.command;

import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.ISticker;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.StickerServiceHolder;
import ch.elexis.core.ui.contacts.views.PatientenListeView;
import ch.elexis.core.ui.dialogs.StickerSelectionDialog;
import ch.elexis.core.ui.util.viewers.CommonViewerContentProvider;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.ui.handlers.HandlerUtil;

public class StickerFilterCommand
extends AbstractHandler
implements IHandler {
    public static final String CMD_ID = "at.medevit.elexis.contacts.core.command.StickerFilter";
    public static final String STATE_ID = "org.eclipse.ui.commands.toggleState";
    private CommonViewerContentProvider.QueryFilter currentFilter;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        boolean state = HandlerUtil.toggleCommandState((Command)event.getCommand());
        PatientenListeView part = (PatientenListeView)HandlerUtil.getActivePart((ExecutionEvent)event);
        if (state) {
            part.getContentProvider().removeQueryFilter(this.currentFilter);
            part.reload();
            this.currentFilter = null;
        } else {
            StickerSelectionDialog stickerDialog = new StickerSelectionDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), "Filtern nach Sticker", IPatient.class);
            if (stickerDialog.open() == 0) {
                this.currentFilter = new StickerFilter(stickerDialog.getSelection());
                part.getContentProvider().addQueryFilter(this.currentFilter);
                part.reload();
            }
        }
        return null;
    }

    private class StickerFilter
    implements CommonViewerContentProvider.QueryFilter {
        private List<ISticker> filterStickers;

        public StickerFilter(List<ISticker> filterStickers) {
            this.filterStickers = filterStickers;
        }

        public void apply(IQuery<?> query) {
            HashSet ids = new HashSet();
            this.filterStickers.forEach(fs -> {
                boolean bl = ids.addAll(StickerServiceHolder.get().getObjectsWithSticker(fs, IPatient.class).stream().map(Identifiable::getId).collect(Collectors.toList()));
            });
            query.and("id", IQuery.COMPARATOR.IN, ids);
        }
    }
}

