/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.util.LocalLock;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IOrderEntry;
import ch.elexis.core.services.IConflictHandler;
import ch.elexis.core.services.ILocalDocumentService;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.services.LocalDocumentServiceHolder;
import ch.elexis.core.ui.text.ITextPlugin;
import ch.elexis.core.ui.text.TextContainer;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.views.Messages;
import ch.elexis.data.Brief;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Person;
import ch.rgw.tools.Money;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.part.ViewPart;

public class BestellBlatt
extends ViewPart
implements ITextPlugin.ICallback {
    public static final String ID = "ch.elexis.BestellBlatt";
    TextContainer text;
    Brief actBest;
    private static final String ERRMSG_CAPTION = Messages.BestellBlatt_CouldNotCreateOrder;
    private static final String ERRMSG_BODY = Messages.BestellBlatt_CouldNotCreateOrderBody;

    public void createPartControl(Composite parent) {
        this.setTitleImage(Images.IMG_PRINTER.getImage());
        this.text = new TextContainer(this.getViewSite());
        this.text.getPlugin().createContainer(parent, this);
    }

    public void createOrder(IContact receiver, List<IOrderEntry> toOrder) {
        List orders = toOrder.stream().filter(oe -> oe.getArticle() != null).collect(Collectors.toList());
        String[][] tbl = new String[orders.size() + 2][];
        int i = 1;
        Money sum = new Money();
        tbl[0] = new String[]{Messages.Core_Count, Messages.Core_Phamacode, Messages.Core_Name, Messages.BestellBlatt_UnitPrice, Messages.BestellBlatt_LinePrice};
        for (IOrderEntry orderEntry : orders) {
            String[] row = new String[5];
            row[0] = Integer.toString(orderEntry.getAmount());
            row[1] = orderEntry.getArticle().getCode();
            row[2] = orderEntry.getArticle().getName();
            Money purchasePrice = new Money(orderEntry.getArticle().getPurchasePrice());
            row[3] = purchasePrice.getAmountAsString();
            Money amount = purchasePrice.multiply((double)orderEntry.getAmount());
            row[4] = amount.getAmountAsString();
            sum.addMoney(amount);
            tbl[i++] = row;
        }
        tbl[i] = new String[]{Messages.Core_Sum, "", "", "", sum.getAmountAsString()};
        this.actBest = this.text.createFromTemplateName(null, "Bestellung", "Bestellung", Kontakt.load((String)receiver.getId()), null);
        if (this.actBest == null) {
            SWTHelper.showError(ERRMSG_CAPTION, ERRMSG_BODY + "'Bestellung'");
            this.getSite().getPage().hideView((IViewPart)this);
        } else {
            this.actBest.setPatient((Person)CoreHub.getLoggedInContact());
            this.text.getPlugin().insertTable("[Bestellung]", 3, tbl, null);
            if (this.text.getPlugin().isDirectOutput()) {
                this.text.getPlugin().print(null, null, true);
                this.getSite().getPage().hideView((IViewPart)this);
                return;
            }
            this.save();
            this.openLocalDocument(this, this.actBest);
        }
    }

    private void openLocalDocument(BestellBlatt view, Brief brief) {
        ILocalDocumentService service = LocalDocumentServiceHolder.getService().orElse(null);
        if (service != null) {
            java.util.Optional file = service.add((Object)brief, new IConflictHandler(){

                public IConflictHandler.Result getResult() {
                    return IConflictHandler.Result.OVERWRITE;
                }
            });
            if (file.isPresent()) {
                Program.launch((String)((File)file.get()).getAbsolutePath());
            } else {
                MessageDialog.openError((Shell)this.getSite().getShell(), (String)ch.elexis.core.ui.commands.Messages.Core_Error, (String)ch.elexis.core.ui.commands.Messages.Core_Document_Not_Opened_Locally);
            }
            if (service.contains((Object)brief)) {
                java.util.Optional lock = LocalLock.getManagedLock((Object)brief);
                lock.ifPresent(localDocumentLock -> localDocumentLock.unlock());
                service.remove((Object)brief, false);
            }
            view.getSite().getPage().hideView((IViewPart)view);
        }
    }

    public void setFocus() {
    }

    @Override
    public void save() {
        if (this.actBest != null) {
            this.actBest.save(this.text.getPlugin().storeToByteArray(), this.text.getPlugin().getMimeType());
        }
    }

    @Override
    public boolean saveAs() {
        return false;
    }

    @Optional
    @Inject
    public void setFixLayout(MPart part, @Named(value="perspectives/fix_layout") boolean currentState) {
        CoreUiUtil.updateFixLayout((MPart)part, (boolean)currentState);
    }
}

