/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.util.dnd;

import ch.elexis.core.data.service.StoreToStringServiceHolder;
import ch.elexis.core.model.Identifiable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;

public class IdentifiableDragSource
implements DragSourceListener {
    private StructuredViewer viewer;
    private List<Identifiable> selection;
    protected static Identifiable draggedObject;
    Transfer myTransfer = TextTransfer.getInstance();

    public IdentifiableDragSource(StructuredViewer viewer) {
        this.viewer = viewer;
        this.setup();
    }

    private void setup() {
        DragSource mine = new DragSource(this.viewer.getControl(), 1);
        mine.setTransfer(new Transfer[]{this.myTransfer});
        mine.addDragListener((DragSourceListener)this);
    }

    public void dragFinished(DragSourceEvent event) {
    }

    public void dragSetData(DragSourceEvent event) {
        StringJoiner sj = new StringJoiner(",");
        for (Identifiable identifiable : this.selection) {
            Optional storeToString = StoreToStringServiceHolder.get().storeToString(identifiable);
            storeToString.ifPresent(s -> {
                StringJoiner stringJoiner2 = sj.add((CharSequence)s);
            });
        }
        event.data = sj.toString().replace(",$", "");
    }

    public void dragStart(DragSourceEvent event) {
        ISelection viewerSelection;
        this.selection = new ArrayList<Identifiable>();
        if (this.viewer != null && (viewerSelection = this.viewer.getSelection()) instanceof IStructuredSelection) {
            for (Object object : ((IStructuredSelection)viewerSelection).toList()) {
                if (!(object instanceof Identifiable)) continue;
                this.selection.add((Identifiable)object);
            }
        }
        if (this.selection == null || this.selection.isEmpty()) {
            event.doit = false;
        }
    }
}

