/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.util;

import ch.elexis.core.ui.UiDesk;
import ch.rgw.tools.TimeTool;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Log {
    public static final int NOTHING = 0;
    public static final int FATALS = 1;
    public static final int ERRORS = 2;
    public static final int WARNINGS = 3;
    public static final int INFOS = 4;
    public static final int DEBUGMSG = 5;
    public static final int TRACE = 6;
    public static final int SYNCMARK = -1;
    private static String[] Levels = new String[]{"OK", "FATAL", "ERROR", "WARNING", "INFO", "DEBUG", "TRACE"};
    private static Logger out = null;
    String prefix;
    private static int LogLevel = 2;
    private static int alertLevel;
    private static String lastError;
    private static Shell doAlert;

    static {
        doAlert = null;
        alertLevel = 1;
    }

    public static void setAlertLevel(int l) {
        alertLevel = l;
    }

    public static void setAlert(Shell cmp) {
        doAlert = cmp;
    }

    public static Log get(String prefix) {
        return new Log(prefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(String message, int level) {
        if (out == null) {
            out = LoggerFactory.getLogger(Log.class);
        }
        Logger logger = out;
        synchronized (logger) {
            String type = "unknown";
            if (level > 0 && level < Levels.length) {
                type = Levels[level];
            }
            switch (level) {
                case 0: {
                    break;
                }
                case -1: {
                    out.info("SYNC: " + message);
                    break;
                }
                case 1: 
                case 2: {
                    out.error(message);
                    break;
                }
                case 3: {
                    out.error(message);
                    break;
                }
                case 4: {
                    out.trace(message);
                    break;
                }
                case 5: {
                    out.debug(message);
                    break;
                }
                default: {
                    out.debug(message);
                }
            }
            if (level <= LogLevel && level <= alertLevel && PlatformUI.isWorkbenchRunning() && level != -1) {
                if (doAlert == null) {
                    doAlert = UiDesk.getTopShell();
                }
                lastError = " |" + type + "| - " + this.prefix + ": " + message;
                if (doAlert != null) {
                    UiDesk.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageBox msg2 = new MessageBox(doAlert, 33);
                            msg2.setMessage(lastError);
                            msg2.open();
                        }
                    });
                }
            }
        }
    }

    public void log(Throwable t, String message, int level) {
        if (!(message != null && message.length() != 0 || (message = t.getMessage()) != null && message.length() != 0)) {
            message = t.getClass().toString();
        }
        this.log(message, level);
        t.printStackTrace();
    }

    public void log(Throwable t) {
        this.log(t, null, 2);
    }

    public static void trace(String msg2) {
        StringBuffer mark = new StringBuffer(100);
        mark.append("--TRACE: ");
        mark.append(new TimeTool().toString(0));
        mark.append(": ").append(msg2);
        out.trace(mark.toString());
    }

    public boolean isDebug() {
        return 5 <= LogLevel;
    }

    public boolean isInfo() {
        return 4 <= LogLevel;
    }

    public boolean isWarn() {
        return 3 <= LogLevel;
    }

    public boolean isError() {
        return 2 <= LogLevel;
    }

    private Log() {
        if (out == null) {
            out = LoggerFactory.getLogger(Log.class);
        }
    }

    private Log(String p) {
        this.prefix = p;
    }
}

