/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.preferences.inputs;

import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.dialogs.KontaktSelektor;
import ch.elexis.core.ui.preferences.ConfigServicePreferenceStore;
import ch.elexis.core.ui.preferences.inputs.Messages;
import ch.elexis.data.Kontakt;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class KontaktFieldEditor
extends FieldEditor {
    private Label contactLabel;
    private String defaultText = Messages.KontaktFieldEditor_PleaseSelect;
    private Kontakt selected;
    private ConfigServicePreferenceStore store;

    protected KontaktFieldEditor() {
    }

    public KontaktFieldEditor(ConfigServicePreferenceStore store, String name, String labelText, Composite parent) {
        super(name, labelText, parent);
        this.store = store;
    }

    protected void adjustForNumColumns(int numColumns) {
        ((GridData)this.contactLabel.getLayoutData()).horizontalSpan = numColumns - 1;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label control = this.getLabelControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns - 1;
        control.setLayoutData((Object)gd);
        Label cLabel = this.getChangeControl(parent);
        cLabel.setLayoutData((Object)new GridData());
    }

    protected void doLoad() {
        if (this.contactLabel == null) {
            return;
        }
        this.selected = Kontakt.load((String)this.store.getString(this.getPreferenceName()));
        if (this.selected.isValid()) {
            this.contactLabel.setText(this.selected.getLabel());
        } else {
            this.contactLabel.setText(this.defaultText);
            this.selected = null;
        }
    }

    protected void doLoadDefault() {
        this.contactLabel.setText(this.defaultText);
        this.selected = null;
    }

    protected void doStore() {
        if (this.selected == null) {
            this.store.setValue(this.getPreferenceName(), null);
        } else {
            this.store.setValue(this.getPreferenceName(), this.selected.getId());
        }
    }

    public int getNumberOfControls() {
        return 2;
    }

    protected Label getChangeControl(final Composite parent) {
        if (this.contactLabel == null) {
            this.contactLabel = new Label(parent, 0);
            this.contactLabel.setForeground(UiDesk.getColor("blau"));
            this.contactLabel.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    KontaktSelektor ksl = new KontaktSelektor(parent.getShell(), Kontakt.class, Messages.KontaktFieldEditor_SelectContact, Messages.KontaktFieldEditor_PleaseSelectContact, Kontakt.DEFAULT_SORT);
                    if (ksl.open() == 0) {
                        KontaktFieldEditor.this.selected = (Kontakt)ksl.getSelection();
                        KontaktFieldEditor.this.contactLabel.setText(KontaktFieldEditor.this.selected.getLabel());
                    } else {
                        KontaktFieldEditor.this.contactLabel.setText(KontaktFieldEditor.this.defaultText);
                        KontaktFieldEditor.this.selected = null;
                    }
                }
            });
        } else {
            this.checkParent((Control)this.contactLabel, parent);
        }
        return this.contactLabel;
    }

    public Kontakt getValue() {
        return this.selected;
    }

    public void set(Kontakt sel) {
        if (sel.isValid()) {
            this.selected = sel;
            this.contactLabel.setText(this.selected.getLabel());
        } else {
            sel = null;
            this.contactLabel.setText(this.defaultText);
        }
    }
}

